<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Investigation_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_doctor_list() {
        $this->db->select('C.*, E.name, E.phone, E.user_id');
        $this->db->from('doctor_charges AS C');
        $this->db->join('employees AS E', 'E.user_id = C.doctor_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('U.role_id', DOCTOR);
        $this->db->where('E.status', 1);
        $this->db->order_by('E.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_employee_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_reference_list() {
        $this->db->select('I.*, E.id as employee_id, E.user_id, E.name, E.phone');
        $this->db->from('invoices AS I');
        $this->db->join('employees AS E', 'E.user_id = I.commission_user_id', 'left');
        $this->db->where('I.commission_payment', 'unpaid');
        $this->db->where('I.commission_user_id >', 0);
        $this->db->where('I.payable_commission >', 0);
        $this->db->where('I.paid_status', 'paid');
        $this->db->where('I.payment_status', 'complete');
        $this->db->group_by('I.commission_user_id');
        return $this->db->get()->result();
    }

    public function get_investigation_reference_list() {
        $this->db->select('I.*, E.id as employee_id, E.user_id, E.name, E.phone');
        $this->db->from('invoices AS I');
        $this->db->join('employees AS E', 'E.user_id = I.commission_user_id', 'left');
        $this->db->where('I.commission_payment', 'unpaid');
        $this->db->where('I.commission_user_id >', 0);
        $this->db->where('I.payable_commission >', 0);
        $this->db->where('I.paid_status', 'paid');
        $this->db->where('I.payment_status', 'complete');
        $this->db->group_by('I.commission_user_id');
        return $this->db->get()->result();
    }

    public function get_investigation_invoice_list($limit, $offset, $status, $form_date, $to_date, $reference_id,  $doctor_id, $created_by, $keyword, $count) {
        $this->db->select('I.*, P.patient_unique_id, P.name as patient_name, P.phone, D.name as doctor, R.name as commission_name, R.phone as commission_phone, PA.id as payemnt_id, PA.payable_amount');
        $this->db->from('invoices AS I');
        $this->db->join('patients AS P', 'P.user_id = I.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = I.ref_dr_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = I.commission_user_id', 'left');
        $this->db->join('payments AS PA', 'PA.invoice_id = I.id AND PA.invoice_type = I.invoice_type', 'left');
        if ($status) {
            $this->db->where('I.commission_payment', $status);
        }
        if ($keyword) {
            $this->db->group_start();
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
            $this->db->or_like('D.name', $keyword, 'both');
            $this->db->or_like('I.custom_invoice_id', $keyword, 'both');
            $this->db->group_end();
        }

        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('I.ref_dr_id', $doctor_id);
        }
        if ($reference_id) {
            $this->db->where('I.commission_user_id', $reference_id);
        }
        if ($created_by) {
            $this->db->where('I.created_by', $created_by);
        }

        $this->db->where('I.commission_user_id >', '0');
        $this->db->where('I.payable_commission >', '0');
        $this->db->where('I.payment_status', 'complete');
        $this->db->where('I.paid_status', 'paid');
        $this->db->order_by('I.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_investigation_payment($id) {
        $this->db->select('P.*, I.custom_invoice_id as bill_invoice, I.bill_date, I.total_bill, I.special_discount, I.discount, I.commission_amount, I.payable_commission, PA.patient_unique_id, PA.name as patient_name, PA.phone, PA.gender, PA.address, E.name as doctor, R.commission_type, R.name as reference, R.id as reference_id, C.name as created_by, M.name as modified_by');
        $this->db->from('payments AS P');
        $this->db->join('invoices AS I', 'I.id = P.invoice_id AND I.invoice_type = P.invoice_type', 'left');
        $this->db->join('patients AS PA', 'PA.user_id = P.patient_id', 'left');
        $this->db->join('employees AS E', 'E.user_id = I.ref_dr_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = I.commission_user_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = P.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = P.modified_by', 'left');
        $this->db->where('P.id', $id);
        return $this->db->get()->row();
    }
    
    public function get_single_investigation_draft_print($invoice_id) {
        $this->db->select('I.*, PA.patient_unique_id, PA.name as patient_name, PA.phone, PA.gender, PA.address, E.name as doctor, R.commission_type, R.name as reference, R.id as reference_id, R.phone as reference_phone, C.name as created_by, M.name as modified_by');
        $this->db->from('invoices AS I');
        $this->db->join('patients AS PA', 'PA.user_id = I.patient_id', 'left');
        $this->db->join('employees AS E', 'E.user_id = I.ref_dr_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = I.commission_user_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = I.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = I.modified_by', 'left');
        $this->db->where('I.id', $invoice_id);
        return $this->db->get()->row();
    }

    public function get_multi_investigation_invoice_list($status, $form_date, $to_date, $reference_id, $doctor_id, $created_by, $keyword) {
        $this->db->select('I.*, P.patient_unique_id, P.name as patient_name, P.phone, D.name as doctor, R.name as commission_name, R.phone as commission_phone, PA.id as payemnt_id, PA.payable_amount');
        $this->db->from('invoices AS I');
        $this->db->join('patients AS P', 'P.user_id = I.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = I.ref_dr_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = I.commission_user_id', 'left');
        $this->db->join('payments AS PA', 'PA.invoice_id = I.id AND PA.invoice_type = I.invoice_type', 'left');
        if ($status) {
            $this->db->where('I.commission_payment', $status);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($reference_id) {
            $this->db->where('I.commission_user_id', $reference_id);
        }

        if ($doctor_id) {
            $this->db->where('I.ref_dr_id', $doctor_id);
        }

        if ($created_by) {
            $this->db->where('I.created_by', $created_by);
        }
        if ($keyword) {
            $this->db->group_start();
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
            $this->db->or_like('D.name', $keyword, 'both');
            $this->db->group_end();
        }
        $this->db->where('I.commission_user_id >', '0');
        $this->db->where('I.payable_commission >', '0');
        $this->db->where('I.payment_status', 'complete');
        $this->db->where('I.paid_status', 'paid');
        $this->db->order_by('I.id', 'DESC');
        return $this->db->get()->result();
    }

    public function get_multi_investigation_payment_invoice($id) {
        $this->db->select('P.*, I.custom_invoice_id as bill_invoice, I.bill_date, I.total_bill, I.discount, PA.patient_unique_id, PA.name as patient, E.name as doctor, R.name as reference, R.user_id as reference_id, C.name as created_by');
        $this->db->from('payments AS P');
        $this->db->join('payment_invoices AS PI', 'PI.id = P.payment_id AND PI.invoice_type = P.invoice_type', 'left');
        $this->db->join('invoices AS I', 'I.id = P.invoice_id AND I.invoice_type = P.invoice_type', 'left');
        $this->db->join('patients AS PA', 'PA.user_id = P.patient_id', 'left');
        $this->db->join('employees AS E', 'E.user_id = I.ref_dr_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = I.commission_user_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = PI.created_by', 'left');
        $this->db->where('PI.id', $id);
        return $this->db->get()->result();
    }

    public function get_multi_patient_reference($id) {
        $this->db->select('P.*, R.commission_type, R.present_address as address, R.name as reference, R.id as reference_id, C.name as created_by');
        $this->db->from('payment_invoices AS P');
        $this->db->join('employees AS R', 'R.user_id = P.commission_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = P.created_by', 'left');
        $this->db->where('P.id', $id);
        return $this->db->get()->row();
    }

    public function get_investigation_by_department_bill($invoice_id, $department_id) {
        $this->db->select('T.*, SUM(ID.rate) as total_rate, SUM(T.mbbs) as total_mbbs, SUM(T.vd) as total_vd, SUM(T.emp) as total_emp, SUM(T.corporate) as total_corporate');
        $this->db->from('diagnostic_tests AS T');
        $this->db->join('invoice_details AS ID', 'ID.investagation_id = T.id', 'left');
        $this->db->where('ID.invoice_id', $invoice_id);
        $this->db->where('T.department_id', $department_id);
        $this->db->group_by('T.department_id');
        return $this->db->get()->row();
    }
}
