<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Category_Model extends MY_Model
{

    function __construct()
    {
        parent::__construct();
    }

    public function get_category_list($limit, $offset, $count)
    {
        $this->db->select('FC.*, C.name as created_by');
        $this->db->from('followup_categories AS FC');
        $this->db->join('employees AS C', 'C.user_id = FC.created_by', 'left');
        $this->db->order_by('C.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_category($id)
    {
        $this->db->select('FC.*, C.name as created_by, M.name as modified_by');
        $this->db->from('followup_categories AS FC');
        $this->db->join('employees AS C', 'C.user_id = FC.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = FC.modified_by', 'left');
        $this->db->where('FC.id', $id);
        return $this->db->get()->row();
    }
}
