<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Patient_Model extends MY_Model
{

    function __construct()
    {
        parent::__construct();
    }

    public function get_employee_list()
    {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST, PATHOLOGIST, RADIOLOGIST, NURSE, STAFF, MARKETING, PHARMACIST));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST, PATHOLOGIST, RADIOLOGIST, NURSE, STAFF, MARKETING, PHARMACIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_patient_list($limit, $offset, $keyword, $create_form_date, $create_to_date, $followup_form_date, $followup_to_date, $status, $gender, $category_id, $created_by, $count)
    {
        $this->db->select('FP.*, FC.name as followup_category, FC.day, P.patient_unique_id,P.name as patient, P.phone,P.dob,P.gender,P.address,P.guardian_name,C.name as created_by');
        $this->db->from('followup_patients AS FP');
        $this->db->join('followup_categories AS FC', 'FC.id = FP.category_id', 'left');
        $this->db->join('patients AS P', 'P.user_id = FP.patient_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = FP.created_by', 'left');
        
        if ($keyword) {
            $this->db->where('P.patient_unique_id', $keyword);
        }
        if ($create_form_date && $create_to_date) {
            $this->db->where("DATE(FP.create_date) BETWEEN '$create_form_date' AND '$create_to_date'");
        }
        if ($followup_form_date && $followup_to_date) {
            $this->db->where("DATE(FP.followup_date) BETWEEN '$followup_form_date' AND '$followup_to_date'");
        }
        if ($status == 1) {
            $this->db->where('FP.status', $status);
        }
        if ($status == 2) {
            $this->db->where('FP.status', 0);
        }
        if ($gender) {
            $this->db->where('P.gender', $gender);
        }
        if ($category_id) {
            $this->db->where('FP.category_id', $category_id);
        }
        if ($created_by) {
            $this->db->where('FP.created_by', $created_by);
        }
        $this->db->order_by('FP.status', 'DESC');
        $this->db->order_by('FP.followup_date', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_patient($id)
    {
        $this->db->select('FP.*, FC.name as followup_category, FC.day, 
        P.patient_unique_id,P.name as patient, P.phone,P.dob,P.gender,P.address,P.guardian_name,
        C.name as created_by, M.name as modified_by');
        $this->db->from('followup_patients AS FP');
        $this->db->join('followup_categories AS FC', 'FC.id = FP.category_id', 'left');
        $this->db->join('patients AS P', 'P.user_id = FP.patient_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = FP.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = FP.modified_by', 'left');
        $this->db->where('FP.id', $id);
        return $this->db->get()->row();
    }

    public function get_last_visited_doctor($id)
    {
        $this->db->select('OP.appointment_date, OP.patient_id, D.name as doctor');
        $this->db->from('opd_patients AS OP');
        $this->db->join('employees AS D', 'D.user_id = OP.doctor_id', 'left');
        $this->db->where('OP.patient_id', $id);
        $this->db->order_by('OP.id', 'DESC');
        return $this->db->get()->row();
    }

    public function get_followup_histories($id)
    {
        $this->db->select('FH.id, FH.create_date, FH.followup_date, FH.status, FH.note, C.name as created_by, M.name as modified_by');
        $this->db->from('followup_histories AS FH');
        $this->db->join('employees AS C', 'C.user_id = FH.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = FH.modified_by', 'left');
        $this->db->where('FH.followup_id', $id);
        $this->db->order_by('FH.id', 'DESC');
        $this->db->limit(7);
        return $this->db->get()->result();
    }

    public function get_search_patient($id)
    {
        $this->db->select('P.user_id,P.patient_unique_id, P.name, P.phone, P.gender, P.dob, P.address');
        $this->db->from('patients AS P');
        $this->db->where('P.patient_unique_id', $id);
        return $this->db->get()->row();
    }

    function duplicate_check_category($category_id, $patient_id)
    {
        $this->db->where('category_id', $category_id);
        $this->db->where('patient_id', $patient_id);
        $this->db->where('status', 1);
        return $this->db->get('followup_patients')->num_rows();
    }
}
