<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Receive_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_receive_list($limit, $offset, $search, $count) {
        $this->db->select('R.*');
        $this->db->from('receives AS R');
        if ($search) {
            $this->db->like('R.from_title', $search);
            $this->db->or_like('R.reference', $search);
            $this->db->or_like('R.address', $search);
            $this->db->or_like('R.to_title', $search);
            $this->db->or_like('R.date', $search);
            $this->db->or_like('R.note', $search);
        }
        $this->db->order_by('R.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }
}
