<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('employee'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_employee'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('hrm/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(EDIT, 'hrm', 'employee')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user font-30 mr-10"></i>
                            <?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('employee'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'hrm', 'employee')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('hrm/employee'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('employee'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('hrm/employee/edit/' . $employee->id), array('name' => 'edit', 'id' => 'edit', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-3 mb-10">
                            <label for="name"><?php echo $this->lang->line('name'); ?></label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($employee->name) ?  $employee->name : ''; ?>" placeholder="<?php echo $this->lang->line('name'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('name'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="bn_name"><?php echo $this->lang->line('bn_name'); ?></label>
                            <input type="text" class="form-control" name="bn_name" id="bn_name" value="<?php echo isset($employee->bn_name) ?  $employee->bn_name : ''; ?>" placeholder="<?php echo $this->lang->line('bn_name'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="phone"><?php echo $this->lang->line('phone'); ?></label>
                            <input type="number" min="0" class="form-control" name="phone" id="phone" value="<?php echo isset($employee->phone) ?  $employee->phone : ''; ?>" placeholder="<?php echo $this->lang->line('phone'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('phone'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="commission_type"><?php echo $this->lang->line('commission'); ?> <?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select" name="commission_type" id="commission_type" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('commission'); ?> <?php echo $this->lang->line('type'); ?></option>
                                <option value="emp" <?php echo isset($employee->commission_type) && $employee->commission_type == 'emp' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('emp'); ?></option>
                                <option value="corporate" <?php echo isset($employee->commission_type) && $employee->commission_type == 'corporate' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('corporate'); ?></option>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="employee_type"><?php echo $this->lang->line('employee'); ?> <?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select" name="employee_type" id="employee_type">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('type'); ?></option>
                                <?php $types = get_employee_type(); ?>
                                <?php foreach ($types as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($employee->employee_type) && $employee->employee_type == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="department_id"><?php echo $this->lang->line('department'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <select class="form-control custom-select select2" name="department_id" id="department_id" onchange="get_designation(this.value)">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($departments as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($employee->department_id) && $employee->department_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('department_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="designation_id"><?php echo $this->lang->line('designation'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <select class="form-control custom-select select2" name="designation_id" id="designation_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($designations as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($employee->designation_id) && $employee->designation_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('designation_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="shift_id"><?php echo $this->lang->line('shift'); ?></label>
                            <select class="form-control custom-select select2" name="shift_id" id="shift_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('shift'); ?></option>
                                <?php foreach ($shifts as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($employee->shift_id) && $employee->shift_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="shift_id" class="form-text text-muted">
                                <?php echo form_error('shift_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="national_id"><?php echo $this->lang->line('national_id'); ?></label>
                            <input type="number" class="form-control" name="national_id" id="national_id" value="<?php echo isset($employee->national_id) ?  $employee->national_id : ''; ?>" placeholder="<?php echo $this->lang->line('national_id'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="birth_date"><?php echo $this->lang->line('birth_date'); ?></label>
                            <input type="text" class="form-control" name="dob" id="dob" value="<?php echo isset($employee->dob) ?  $employee->dob : ''; ?>" placeholder="<?php echo $this->lang->line('birth_date'); ?>" autocomplete="off">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('birth_date'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="joining_date"><?php echo $this->lang->line('join_date'); ?></label>
                            <input type="text" class="form-control" name="joining_date" id="joining_date" value="<?php echo isset($employee->joining_date) ? $employee->joining_date : ''; ?>" placeholder="<?php echo $this->lang->line('join_date'); ?>" autocomplete="off">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('join_date'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="gender"><?php echo $this->lang->line('gender'); ?></label>
                            <select class="form-control custom-select" name="gender" id="gender" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $genders = get_genders(); ?>
                                <?php foreach ($genders as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($employee->gender) && $employee->gender == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('gender'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="religion"><?php echo $this->lang->line('religion'); ?></label>
                            <select class="form-control custom-select" name="religion" id="religion">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $religions = get_religion(); ?>
                                <?php foreach ($religions as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($employee->religion) && $employee->religion == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('religion'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="blood_group"><?php echo $this->lang->line('blood_group'); ?></label>
                            <select class="form-control custom-select" name="blood_group" id="blood_group">
                                <option selected><?php echo $this->lang->line('select'); ?></option>
                                <?php $bloods = get_blood_group(); ?>
                                <?php foreach ($bloods as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($employee->blood_group) && $employee->blood_group == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="marital_status"><?php echo $this->lang->line('marital_status'); ?></label>
                            <select class="form-control custom-select" name="marital_status" id="marital_status">
                                <option selected><?php echo $this->lang->line('select'); ?></option>
                                <?php $marital_status = get_marital_status(); ?>
                                <?php foreach ($marital_status as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($employee->marital_status) && $employee->marital_status == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('present'); ?> <?php echo $this->lang->line('address'); ?></span>
                                </div>
                                <textarea class="form-control" name="present_address" id="present_address" aria-label="<?php echo $this->lang->line('present'); ?> <?php echo $this->lang->line('address'); ?>"><?php echo isset($employee->present_address) ?  $employee->present_address : ''; ?></textarea>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('permanent'); ?> <?php echo $this->lang->line('address'); ?></span>
                                </div>
                                <textarea class="form-control" name="permanent_address" id="permanent_address" aria-label="<?php echo $this->lang->line('permanent'); ?> <?php echo $this->lang->line('address'); ?>"><?php echo isset($employee->permanent_address) ?  $employee->permanent_address : ''; ?></textarea>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="role_id"><?php echo $this->lang->line('role'); ?></label>
                            <select class="form-control custom-select" name="role_id" id="role_id" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($roles as $obj) { ?>
                                    <?php if ($this->session->userdata('role_id') != SUPER_ADMIN) { ?>
                                        <?php if (in_array($obj->id, array(SUPER_ADMIN, PATIENT, VD, DOCTOR))) {
                                            continue;
                                        } ?>
                                    <?php } ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($employee) && $employee->role_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('role_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="email"><?php echo $this->lang->line('email'); ?></label>
                            <input type="text" class="form-control" name="email" id="email" value="<?php echo isset($employee->email) ?  $employee->email : ''; ?>" placeholder="<?php echo $this->lang->line('email'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="username"><?php echo $this->lang->line('username'); ?></label>
                            <input type="text" disabled class="form-control" name="username" id="username" value="<?php echo isset($employee->username) ?  $employee->username : ''; ?>" placeholder="<?php echo $this->lang->line('username'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('username'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="device_id "><?php echo $this->lang->line('device_id'); ?></label>
                            <input type="number" class="form-control" name="device_id" id="device_id" value="<?php echo isset($employee->device_id) ?  $employee->device_id : ''; ?>" placeholder="<?php echo $this->lang->line('device_id'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="sort_by"><?php echo $this->lang->line('sort_by'); ?></label>
                            <input type="number" class="form-control" name="sort_by" id="sort_by" value="<?php echo isset($employee->sort_by) ?  $employee->sort_by : ''; ?>" placeholder="<?php echo $this->lang->line('sort_by'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="photo"><?php echo $this->lang->line('photo'); ?></label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                        <input type="file" name="photo">
                                        <input type="hidden" name="prev_photo" id="prev_photo" value="<?php echo $employee->photo; ?>" />
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-1 mb-10">
                            <div class="avatar">
                                <?php if ($employee->photo != '') { ?>
                                    <img class="avatar-img rounded" src="<?php echo UPLOAD_PATH; ?>employee-photo/<?php echo $employee->photo; ?>" alt="<?php echo $employee->name; ?>" />
                                <?php } elseif ($employee->gender == 'male') { ?>
                                    <img class="avatar-img rounded" src="<?php echo IMG_URL; ?>male.png" alt="male" />
                                <?php } else { ?>
                                    <img class="avatar-img rounded" src="<?php echo IMG_URL; ?>female.png" alt="female" />
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="signature"><?php echo $this->lang->line('signature'); ?></label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                        <input type="file" name="signature">
                                        <input type="hidden" name="prev_signature" id="prev_signature" value="<?php echo $employee->signature; ?>" />
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-1 mb-10">
                            <div class="avatar">
                                <?php if ($employee->signature != '') { ?>
                                    <img class="avatar-img rounded" src="<?php echo UPLOAD_PATH; ?>employee-signature/<?php echo $employee->signature; ?>" alt="<?php echo $employee->name; ?>" />
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="resume"><?php echo $this->lang->line('resume'); ?></label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                        <input type="file" name="resume">
                                        <input type="hidden" name="prev_resume" id="prev_resume" value="<?php echo $employee->resume; ?>" />
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-1 mb-10">
                            <div class="avatar mt-40 ml-10">
                                <?php if ($employee->resume != '') { ?>
                                    <a href="<?php echo UPLOAD_PATH; ?>employee-resume/<?php echo $employee->resume; ?>"><i class="fa fa-download" aria-hidden="true"></i></a>
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-4 mt-10">
                            <div class="custom-control custom-checkbox checkbox-primary">
                                <input type="checkbox" class="custom-control-input" name="is_view_on_web" id="is_view_on_web" value="1" <?php echo $employee->is_view_on_web ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="is_view_on_web"><?php echo $this->lang->line('is_view_on_web'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-4 mt-10">
                            <div class="custom-control custom-checkbox checkbox-cyan">
                                <input type="checkbox" class="custom-control-input" name="status" id="status" value="1" <?php echo $employee->status ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="status"><?php echo $this->lang->line('status'); ?></label>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="id" id="id" value="<?php echo $employee->id; ?>" />
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('hrm/employee'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>

<script>
    $(".select2").select2();
    $("#dob, #joining_date").daterangepicker({
        autoUpdateInput: false,
        singleDatePicker: true,
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY-MM-DD'
        }
    });
    $('input[id="dob"], input[id="joining_date"]').on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
    });
</script>
<script>
    function get_designation(department_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_department_by_designation'); ?>",
            data: {
                department_id: department_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#designation_id').html(response);
                }
            }
        });
    };
</script>