<!-- Container -->
<div class="container-fluid">
    <!-- Row -->
    <div class="row">
        <div class="col-xl-12 pa-0">
            <!-- Profile Heading -->
            <?php $this->load->view('header'); ?>
            <!-- Profile Body -->
            <!-- Container -->
            <div class="container mt-sm-60 mt-30">
                <div class="hk-row">
                    <div class="col-lg-8">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <?php if (has_permission(VIEW, 'hrm', 'employee')) { ?>
                                    <h6 class="card-header d-flex align-items-center">
                                        <i class="fa fa-user font-30 mr-10"></i>
                                        <?php echo $this->lang->line('employee'); ?> <?php echo $this->lang->line('info'); ?>
                                    </h6>
                                <?php } ?>
                                <?php if (has_permission(VIEW, 'hrm', 'employee')) { ?>
                                    <div class="align-items-center">
                                        <a href="#" class="btn btn-xs btn-primary">
                                            <i class="fa fa-download"></i>
                                        </a>
                                        <button class="btn btn-xs btn-success">
                                            <i class="fa fa-print"></i>
                                        </button>
                                    </div>
                                <?php } ?>
                            </div>
                            <div class="card-body pt-0">
                                <div class="table-wrap">
                                    <div class="table-responsive">
                                        <table class="table table-sm table-striped table-bordered">
                                            <tbody>
                                                <tr>
                                                    <td class="w-20"><?php echo $this->lang->line('name'); ?></td>
                                                    <td class="w-30"><?php echo $profile->name; ?></td>
                                                    <td class="w-20"><?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('name'); ?></td>
                                                    <td class="w-30"><?php echo $profile->bn_name; ?></td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo $this->lang->line('department'); ?></td>
                                                    <td><?php echo $profile->department; ?></td>
                                                    <td><?php echo $this->lang->line('designation'); ?></td>
                                                    <td><?php echo $profile->designation; ?></td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo $this->lang->line('phone'); ?></td>
                                                    <td><?php echo $profile->phone; ?></td>
                                                    <td><?php echo $this->lang->line('email'); ?></td>
                                                    <td><?php echo $profile->email; ?></td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo $this->lang->line('commission'); ?> <?php echo $this->lang->line('type'); ?></td>
                                                    <td><?php echo $this->lang->line($profile->commission_type); ?></td>
                                                    <td><?php echo $this->lang->line('employee'); ?> <?php echo $this->lang->line('type'); ?></td>
                                                    <td><?php echo $this->lang->line($profile->employee_type); ?></td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo $this->lang->line('gender'); ?></td>
                                                    <td><?php echo $this->lang->line($profile->gender); ?></td>
                                                    <td><?php echo $this->lang->line('religion'); ?></td>
                                                    <td><?php echo $this->lang->line($profile->religion); ?></td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo $this->lang->line('marital_status'); ?></td>
                                                    <td><?php echo $this->lang->line($profile->marital_status); ?></td>
                                                    <td><?php echo $this->lang->line('blood_group'); ?></td>
                                                    <td><?php echo $this->lang->line($profile->blood_group); ?></td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo $this->lang->line('dob'); ?></td>
                                                    <td><?php echo $profile->dob ? date('M d, Y', strtotime($profile->dob)) : null; ?></td>
                                                    <td><?php echo $this->lang->line('join_date'); ?></td>
                                                    <td><?php echo $profile->joining_date ? date('M d, Y', strtotime($profile->joining_date)) : null; ?></td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo $this->lang->line('present'); ?> <?php echo $this->lang->line('address'); ?></td>
                                                    <td><?php echo $profile->present_address; ?></td>
                                                    <td><?php echo $this->lang->line('permanent'); ?> <?php echo $this->lang->line('address'); ?></td>
                                                    <td><?php echo $profile->permanent_address; ?></td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo $this->lang->line('national_id'); ?></td>
                                                    <td><?php echo $profile->national_id; ?></td>
                                                    <td><?php echo $this->lang->line('sort_by'); ?></td>
                                                    <td><?php echo $profile->sort_by; ?></td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo $this->lang->line('signature'); ?></td>
                                                    <td>
                                                        <?php if ($profile->signature) { ?>
                                                            <a target="_blank" href="<?php echo UPLOAD_PATH; ?>employee-signature/<?php echo $profile->signature; ?>" class="btn btn-success btn-xs"><i class="fa fa-download"></i> <?php echo $this->lang->line('download'); ?></a>
                                                        <?php } ?>
                                                    </td>
                                                    <td><?php echo $this->lang->line('resume'); ?></td>
                                                    <td>
                                                        <?php if ($profile->resume) { ?>
                                                            <a target="_blank" href="<?php echo UPLOAD_PATH; ?>employee-resume/<?php echo $profile->resume; ?>" class="btn btn-success btn-xs"><i class="fa fa-download"></i> <?php echo $this->lang->line('download'); ?></a>
                                                        <?php } ?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo $this->lang->line('is_view_on_web'); ?></td>
                                                    <td><?php echo $profile->is_view_on_web ? '<span class="badge badge-success">' . $this->lang->line('yes') . '</span>' : '<span class="badge badge-success">' . $this->lang->line('no') . '</span>'; ?></td>
                                                    <td><?php echo $this->lang->line('status'); ?></td>
                                                    <td><?php echo $profile->status ? '<span class="badge badge-success">' . $this->lang->line('active') . '</span>' : '<span class="badge badge-success">' . $this->lang->line('in_active') . '</span>'; ?></td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo $this->lang->line('created_by'); ?></td>
                                                    <td><?php echo $profile->created_by; ?></td>
                                                    <td><?php echo $this->lang->line('date'); ?></td>
                                                    <td><?php echo date('M d, Y h:ia', strtotime($profile->created_at)); ?></td>
                                                </tr>
                                                <?php if ($this->session->userdata('role_id') == SUPER_ADMIN || !empty(custom_permission('modified_by'))) { ?>
                                                    <tr>
                                                        <td><?php echo $this->lang->line('modified_by'); ?></td>
                                                        <td><?php echo $profile->modified_by; ?></td>
                                                        <td><?php echo $this->lang->line('date'); ?></td>
                                                        <td><?php echo $profile->modified_by ? date('M d, Y h:ia', strtotime($profile->modified_at)) : ''; ?></td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <?php if ($profile->about) { ?>
                                <div class="card-footer justify-content-between">
                                    <?php echo $profile->about; ?>
                                </div>
                            <?php } ?>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <?php if ($this->session->userdata('role_id') == SUPER_ADMIN || $this->session->userdata('role_id') == ADMIN) { ?>
                            <!-- Login Info -->
                            <div class="card">
                                <div class="card-header d-flex justify-content-between">
                                    <?php if (has_permission(VIEW, 'hrm', 'employee')) { ?>
                                        <h6 class="card-header d-flex align-items-center">
                                            <i class="fa fa-key font-30 mr-10"></i>
                                            <?php echo $this->lang->line('login'); ?> <?php echo $this->lang->line('info'); ?>
                                        </h6>
                                    <?php } ?>
                                </div>
                                <div class="card-body pt-0">
                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item">
                                            <i class="fa fa-user font-18 text-light-20 mr-10"></i>
                                            <span><?php echo $this->lang->line('username'); ?>:</span></span>
                                            <span class="ml-5 text-dark"><?php echo $profile->username; ?></span>
                                        </li>
                                        <li class="list-group-item">
                                            <i class="fa fa-key font-18 text-light-20 mr-10"></i>
                                            <span><?php echo $this->lang->line('password'); ?>:</span></span>
                                            <span class="ml-5 text-dark"><?php echo base64_decode($profile->temp_password); ?></span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        <?php } ?>


                        <!-- Reference Info -->
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <?php if (has_permission(VIEW, 'hrm', 'employee')) { ?>
                                    <h6 class="card-header d-flex align-items-center">
                                        <i class="fa fa-users font-30 mr-10"></i>
                                        <?php echo $this->lang->line('reference'); ?> <?php echo $this->lang->line('info'); ?>
                                    </h6>
                                <?php } ?>
                            </div>
                            <div class="card-body">
                                <div class="row text-center">
                                    <div class="col-4 border-right pr-0">
                                        <div class="pa-5">
                                            <span class="d-block display-6 text-dark mb-5">154</span>
                                            <span class="d-block text-capitalize font-14"><?php echo $this->lang->line('profile'); ?></span>
                                        </div>
                                    </div>
                                    <div class="col-4 border-right px-0">
                                        <div class="pa-5">
                                            <span class="d-block display-6 text-dark mb-5">65</span>
                                            <span class="d-block text-capitalize font-14"><?php echo $this->lang->line('patient'); ?></span>
                                        </div>
                                    </div>
                                    <div class="col-4 pl-0">
                                        <div class="pa-5">
                                            <span class="d-block display-6 text-dark mb-5">433</span>
                                            <span class="d-block text-capitalize font-14"><?php echo $this->lang->line('investigation'); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Education Info -->
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <?php if (has_permission(VIEW, 'hrm', 'employee')) { ?>
                                    <h6 class="card-header d-flex align-items-center">
                                        <i class="fa fa-university font-30 mr-10"></i>
                                        <?php echo $this->lang->line('education'); ?> <?php echo $this->lang->line('info'); ?>
                                    </h6>
                                <?php } ?>
                            </div>
                            <div class="card-body">
                                Comming
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Container -->
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->