<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Assistant.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Assistant
 * @description     : Manage IPD Assistant Chart.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Assistant extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Assistant_Model', 'assistant', true);
        $this->load->model('Ipd_Model', 'ipd', true);
        $this->data['doctors'] = $this->assistant->get_doctor_list();
    }

    public function index($ipd_id) {

        check_permission(VIEW);

        $this->data['patient'] = $this->ipd->get_single_ipd_patient($ipd_id);
        $this->data['total_investigation_due'] = $this->ipd->get_total_investigation_due($this->data['patient']->patient_id);
        $this->data['total_pharmacy_due'] = $this->ipd->get_total_pharmacy_due($this->data['patient']->patient_id);
        $this->data['total_ipd_advanced'] = $this->ipd->get_total_ipd_advaced($ipd_id, $this->data['patient']->patient_id);
        

        $search = trim($this->input->get('search'));
        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);
        if ($search) {
            $config['base_url'] = site_url('ipd/assistant/index/' . $ipd_id . '/?search=' . $search);
        } else {
            $config['base_url'] = current_url();
        }
        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        $config['total_rows'] = $this->assistant->get_patient_assistant_list($config['per_page'], $offset, $ipd_id, $search, $count = TRUE);
        $this->pagination->initialize($config);
        $this->data['assistants'] = $this->assistant->get_patient_assistant_list($config['per_page'], $offset, $ipd_id, $search, $count = FALSE);
        $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        $this->data['search'] = $search;

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('assistant') . ' ' . $this->lang->line('chart') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('assistant/index', $this->data);
    }

    /*****************Function add**********************************
     * @type            : Function
     * @function name   : add
     * @description     : Load "Add Assistant" user interface
     *                    and process to store "ipd_assistants" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function add() {

        check_permission(ADD);

        if ($_POST) {
            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('doctor_id', $this->lang->line('assistant') . ' ' . $this->lang->line('name'), 'trim|required');
            $this->form_validation->set_rules('charge', $this->lang->line('doctor') . ' ' . $this->lang->line('charge'), 'trim|required');
            if ($this->form_validation->run() === TRUE) {
                $data['ipd_id'] = $this->input->post('ipd_id');
                $data['patient_id'] = $this->input->post('patient_id');
                $data['type'] = 'assistant';
                $data['doctor_id'] = $this->input->post('doctor_id');
                $data['charge'] = $this->input->post('charge');
                $data['date'] = date('Y-m-d H:i', strtotime($this->input->post('date')));
                $data['instruction'] = $this->input->post('instruction');
                $data['assistant_status'] = 'complete';
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();
                $insert_id = $this->assistant->insert('ipd_assistants', $data);
                if ($insert_id) {
                    $patient = $this->assistant->get_single('patients', array('user_id' => $data['patient_id']));
                    create_log('Has been created a assistant : ' . $patient->name);
                    success($this->lang->line('insert_success'));
                    redirect('ipd/assistant/index/' . $data['ipd_id']);
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('ipd/assistant/index/' . $data['ipd_id']);
                }
            } else {
                $this->data = $_POST;
            }
        }
    }

    /*****************Function get_assistant**********************************
     * @type            : Function
     * @function name   : get_assistant
     * @description     : Load "Single Assistant" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function get_assistant($id) {
        if ($id > 0) {
            $assistant = $this->assistant->get_single('ipd_assistants', array('id' => $id));
            echo (json_encode($assistant));
        }
    }

    /*****************Function edit**********************************
     * @type            : Function
     * @function name   : edit
     * @description     : Load Update "Assistant Chart" user interface
     *                    with populate "Assistant Chart" value
     *                    and process to update "ipd_assistants" into database
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function edit() {

        check_permission(EDIT);

        if ($_POST) {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('doctor_id', $this->lang->line('assistant') . ' ' . $this->lang->line('name'), 'trim|required');
            $this->form_validation->set_rules('charge', $this->lang->line('doctor') . ' ' . $this->lang->line('charge'), 'trim|required');
            if ($this->form_validation->run() === TRUE) {
                $data['type'] = 'assistant';
                $data['doctor_id'] = $this->input->post('doctor_id');
                $data['charge'] = $this->input->post('charge');
                $data['date'] = date('Y-m-d H:i', strtotime($this->input->post('date')));
                $data['instruction'] = $this->input->post('instruction');
                $data['assistant_status'] = $this->input->post('assistant_status');
                $data['note'] = $this->input->post('note');
                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();

                $this->assistant->update('ipd_assistants', $data, array('id' => $this->input->post('assistant_id')));
                $patient = $this->assistant->get_single('patients', array('user_id' => $this->input->post('patient_id')));
                create_log('Has been updated a assistant : ' . $patient->name);
                $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('update_success'));
            } else {
                $msg = array(
                    'doctor_id' => form_error('doctor_id'),
                    'date' => form_error('date'),
                );
                $array = array('status' => 'failed', 'error' => $msg, 'message' => '');
            }

            echo json_encode($array);
        }
    }

    /*     * ***************Function get_single_assistant**********************************
     * @type            : Function
     * @function name   : get_single_assistant
     * @description     : "Load single assistant information" from database                  
     *                    to the user interface   
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_single_assistant() {
        $id = $this->input->post('id');
        $this->data['assistant'] = $this->assistant->get_single_assistant($id);
        echo $this->load->view('ipd/assistant/view', $this->data);
    }

    /*****************Function get_doctor_charge**********************************
     * @type            : Function
     * @function name   : get_doctor_charge
     * @description     : Load "IPD Doctor Charge" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function get_doctor_charge() {
        $user_id = $this->input->post('user_id');
        if ($user_id > 0) {
            $doctor_charges = $this->assistant->get_single('assistants', array('user_id' => $user_id));
            $doctor_charge = array(
                'charge' => $doctor_charges->charge
            );
        }
        echo (json_encode($doctor_charge));
    }

    /*****************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "Assistant" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect($_SERVER['HTTP_REFERER']);
        }

        $assistant = $this->assistant->get_single('ipd_assistants', array('id' => $id));
        $patient = $this->assistant->get_single('patients', array('user_id' => $assistant->patient_id));

        if ($this->ipd->delete('ipd_assistants', array('id' => $id))) {
            create_log('Has been deleted a assistant : ' . $patient->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
}
