<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Booking_Model extends MY_Model
{

    function __construct()
    {
        parent::__construct();
    }

    public function get_employee($search)
    {
        $this->db->select('E.user_id as id, E.name, E.present_address, E.phone, E.bn_name');
        $this->db->from('employees AS E');
        if ($search) {
            $this->db->like('E.user_id', $search);
            $this->db->or_like('E.phone', $search);
            $this->db->or_like('E.name', $search);
            $this->db->or_like('E.present_address', $search);
        }
        $this->db->where('E.status', 1);
        $this->db->order_by('E.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_patient($search)
    {
        $this->db->select('P.user_id as id, P.patient_unique_id, P.name, P.address, P.phone, P.guardian_name');
        $this->db->from('patients AS P');
        if ($search) {
            $this->db->like('P.patient_unique_id', $search);
            $this->db->or_like('P.phone', $search);
            $this->db->or_like('P.name', $search);
            $this->db->or_like('P.gender', $search);
            $this->db->or_like('P.address', $search);
        }
        $this->db->where('P.status', 1);
        $this->db->order_by('P.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_booking_list($limit, $offset, $type, $search, $count = 0)
    {
        $this->db->select('B.*, P.patient_unique_id, P.name as patient, E.name as employee, E.phone as employee_phone, 
        BB.name as bed, BG.name as bed_group, BT.name as bed_type, F.name as floor');
        $this->db->from('bed_bookings AS B');
        $this->db->join('patients AS P', 'P.user_id = B.patient_id', 'left');
        $this->db->join('employees AS E', 'E.user_id = B.booking_id', 'left');
        $this->db->join('beds AS BB', 'BB.id = B.bed_id', 'left');
        $this->db->join('bed_groups AS BG', 'BG.id = B.bed_group_id', 'left');
        $this->db->join('bed_types AS BT', 'BT.id = BB.type_id', 'left');
        $this->db->join('floors AS F', 'F.id = BG.floor_id', 'left');
        if ($type == 2) {
            $this->db->where('B.is_active', 2);
        } else if ($type == 0) {
            $this->db->where('B.is_active >', 0);
        } else {
            $this->db->where('B.is_active', 1);
        }
        if ($search) {
            $this->db->group_start();
            $this->db->like('P.patient_unique_id', $search);
            $this->db->or_like('P.phone', $search);
            $this->db->or_like('P.name', $search);
            $this->db->or_like('P.address', $search);
            $this->db->or_like('E.name', $search);
            $this->db->or_like('E.phone', $search);
            $this->db->or_like('B.patient_name', $search);
            $this->db->or_like('B.address', $search);
            $this->db->or_like('B.booking_name', $search);
            $this->db->or_like('B.phone', $search);
            $this->db->or_like('B.remark', $search);
            $this->db->group_end();
        }
        $this->db->order_by('B.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_booking($id)
    {
        $this->db->select('B.*, P.patient_unique_id, P.name as patient, E.name as employee, E.phone as employee_phone, 
        BB.name as bed, BG.name as bed_group, BT.name as bed_type, F.name as floor,
        C.name as created_by, M.name as modified_by');
        $this->db->from('bed_bookings AS B');
        $this->db->join('patients AS P', 'P.user_id = B.patient_id', 'left');
        $this->db->join('employees AS E', 'E.user_id = B.booking_id', 'left');
        $this->db->join('beds AS BB', 'BB.id = B.bed_id', 'left');
        $this->db->join('bed_groups AS BG', 'BG.id = B.bed_group_id', 'left');
        $this->db->join('bed_types AS BT', 'BT.id = BB.type_id', 'left');
        $this->db->join('floors AS F', 'F.id = BG.floor_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = B.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = B.modified_by', 'left');
        $this->db->where('B.id', $id);
        return $this->db->get()->row();
    }
}
