<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Medicine_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_medicine_chart_list($limit, $offset, $ipd_id, $search, $count) {
        $this->db->select('MC.*, D.name as doctor, D.specialist, N.name as nurse, P.patient_unique_id, P.name as patient_name, P.gender, P.dob, P.phone, P.address');
        $this->db->from('ipd_medicine_charts AS MC');
        $this->db->join('patients AS P', 'P.user_id = MC.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = MC.doctor_id', 'left');
        $this->db->join('employees AS N', 'N.user_id = MC.nurse_id', 'left');
        $this->db->join('ipd_patients AS IP', 'IP.id = MC.ipd_id', 'left');
        if ($search) {
            $this->db->group_start();
            $this->db->like('P.patient_unique_id', $search);
            $this->db->or_like('P.phone', $search);
            $this->db->or_like('P.name', $search);
            $this->db->or_like('P.bn_name', $search);
            $this->db->or_like('P.gender', $search);
            $this->db->or_like('P.religion', $search);
            $this->db->or_like('P.blood_group', $search);
            $this->db->or_like('P.marital_status', $search);
            $this->db->or_like('P.address', $search);
            $this->db->or_like('D.name', $search);
            $this->db->or_like('N.name', $search);
            $this->db->or_like('MC.dose', $search);
            $this->db->or_like('MC.route', $search);
            $this->db->or_like('MC.medicine_name', $search);
            $this->db->or_like('MC.medicine_name', $search);
            $this->db->group_end();
        }
        $this->db->where('MC.ipd_id', $ipd_id);
        $this->db->order_by('MC.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_medicine_chart($id) {
        $this->db->select('MC.*, D.name as doctor, D.specialist, N.name as nurse, P.patient_unique_id, P.name as patient_name, P.gender, P.dob, P.phone, P.address, C.name as created_by, M.name as modified_by');
        $this->db->from('ipd_medicine_charts AS MC');
        $this->db->join('patients AS P', 'P.user_id = MC.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = MC.doctor_id', 'left');
        $this->db->join('employees AS N', 'N.user_id = MC.nurse_id', 'left');
        $this->db->join('ipd_patients AS IP', 'IP.id = MC.ipd_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = MC.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = MC.modified_by', 'left');
        $this->db->where('MC.id', $id);
        return $this->db->get()->row();
    }
}
