<!DOCTYPE html>
<html>

<head>
    <title>Print Invoice</title>

    <style>
        body {
            font-family: monospace;
            font-size: 14px;
        }

        .page {
            width: 64%;
            margin: 0 auto;
        }

        @page {
            size: A4;
            margin: 0;
        }

        @media print {

            html,
            body {
                font-family: Arial, Helvetica, sans-serif;
            }

            .page {
                width: 64%;
                margin: 0 auto;
                border: initial;
                border-radius: initial;
                min-height: initial;
                box-shadow: initial;
                background: initial;
                page-break-after: always;
            }
        }

        .patient_copy {
            page-break-after: always;
            display: block;
            margin-top: 100px;
        }

        .diagnostic_copy {
            display: block;
            margin-top: 100px;
        }

        .title {
            width: 80%;
            font-size: 14px;
            font-weight: bold;
            border: 1px solid #333;
            padding: 5px;
            font-family: monospace;
            text-transform: uppercase;
            letter-spacing: 2px;
            border-radius: 3px;
            text-align: center;
            margin: 3px auto;
        }

        .paid {
            width: 25%;
            margin: 30px auto 0 auto;
            text-align: center;
            font-size: 25px;
            font-weight: bold;
            background: #eee;
            border: 0.5px solid #b4b4b4;
            padding: 3px 10px;
            font-family: monospace;
            text-transform: uppercase;
            letter-spacing: 5px;
            border-radius: 3px;
        }

        .table {
            font-size: 14px;
            width: 100%;
            border-collapse: collapse;
        }

        .patient_table {
            width: 100%;
            text-align: left;
            border-collapse: collapse;
            margin-top: 5px;
            border: 0.5px solid #b4b4b4;
        }

        .patient_table tbody td {
            color: #000;
            padding: 2px;
            vertical-align: top;
            border: 0;
        }

        /* test_table */
        .test_table {
            margin-top: 10px;
            width: 100%;
            text-align: left;
            border-collapse: collapse;
            font-size: 10px;
            border: 0.5px solid #b4b4b4;
        }

        .test_table tbody td {
            color: #000;
            padding: 0px 4px;
            vertical-align: top;
            border: 0.5px solid #b4b4b4;
        }

        /*  payment_info*/
        .payment_table {
            font-size: 14px;
            width: 100%;
            text-align: left;
        }

        .payment_table tbody td {
            vertical-align: top;
            border: 0;
        }

        .table .top-header thead,
        tbody th,
        td {
            border: 0;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="patient_copy">
            <table class="table top-header" style="text-align: center; margin-botto: 15px;">
                <tbody>
                    <img src="<?php echo IMG_URL; ?>bill_head.png" alt="h" width="100%">
                </tbody>
            </table>
          <table class="table">
          	<tr>
              <td style="width: 25%;">
                <img align="left" src="<?php echo site_url('opd/set_barcode/' . $patient->patient_unique_id); ?>" alt="" height="30" width="80%">
              </td>
              <td>
              	<div class="title">Patient Copy</div>
              </td>
              <td style="width: 25%;">
              	<img align="right" src="<?php echo site_url('opd/set_barcode/' . $patient->patient_unique_id); ?>" alt="" height="30" width="80%">
              </td>            
            </tr>
          </table>  
            
            <!-- Patient Info Start-->
            <table class="table patient_table" style="border: 1px solid #000;">
                <tr>
                  	<td style="width: 50%;">
                        <span>Name :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->patient_name; ?></span>
                    </td>
                    <td style="width: 35%;">
                        <span>Patient ID :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->patient_unique_id; ?></span>
                    </td>
                    
                </tr>
                <tr>
                    <td>
                        <span>Age :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->dob != NULL ? floor((time() - strtotime($patient->dob)) / 31556926) : ''; ?>Y</span>
                    </td>
                  	<td>
                        <span>Date :</span>
                        <span><?php echo date('d/m/Y h:i A'); ?></span>
                    </td>
                </tr>
                <tr>                    
                    <td>
                        <span>Gender :</span>
                        <span style="text-transform: capitalize; font-weight: bold;"><?php echo $this->lang->line($patient->gender); ?></span>
                    </td>
                    <td>
                        <span>Contact No :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->phone; ?></span>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <span>Ref. By :</span>
                        <span style="font-size:12px; text-transform: uppercase; font-weight: bold;">
                            <?php echo $patient->doctor ? $patient->doctor . ', ' . $patient->specialist : ''; ?>
                        </span>
                    </td>
                </tr>
            </table>
            <!-- Patient Info End-->

            <table class="test_table" id="vue-app">
                <thead>
                    <tr>
                        <td width="15%" align="left"><b>SL. No</b></td>
                        <td width="55%" align="left"><b>Service Name</b></td>
                        <td width="10%" align="left"><b>Qty</b></td>
                        <td width="10%" align="right"><b>Rate</b></td>
                        <td width="10%" align="right"><b>Total</b></td>
                    </tr>
                </thead>
                <tbody v-if="adf.charges.length>0">
                    <tr v-for="(charge, index) in adf.charges">
                        <td class="text-center">{{ index + 1}}</td>
                        <td class="text-left">
                            <span v-html="charge.name"></span>
                        </td>
                        <td class="text-center">
                            {{ charge.quantity }}
                        </td>
                        <td class="text-left">
                            <span v-html="charge.price"></span>
                        </td>
                        <td class="text-right">
                            {{ charge.total }}
                        </td>
                    </tr>
                    <tr class="bg-transparent">
                        <td colspan="4" class="text-right text-light">Sub Total</td>
                        <td class="text-right">{{ calc.bill }}</td>
                    </tr>
                    <tr class="bg-transparent">
                        <td colspan="4" class="text-right text-light border-top-0">Discount</td>
                        <td class="text-right border-top-0">0.00</td>
                    </tr>
                    <tr class="bg-transparent">
                        <td colspan="4" class="text-right text-light border-top-0">Net Payable</td>
                        <td class="text-right border-top-0">{{ calc.payable }}</td>
                    </tr>
                    <tr class="bg-transparent">
                        <td colspan="4" class="text-right text-light border-top-0">Advanced Amount</td>
                        <td class="text-right border-top-0">{{ advanced }}</td>
                    </tr>
                </tbody>
                <tfoot class="border-bottom border-1">
                    <tr>
                        <th colspan="4" class="text-right font-weight-600">Due Amount</th>
                        <th class="text-right font-weight-600 text-red">{{ calc.due }}</th>
                    </tr>
                </tfoot>
            </table>
            <p style="margin-top:30px;">
                <span style="font-size: 14px; font-weight: bold;">Prepared By:</span>
                <?php echo $this->session->userdata('name'); ?>
            </p>
        </div>
    </div>
</body>

</html>

<!-- Autocomplete -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/collect.js/4.28.4/collect.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.20.0/axios.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/vue@2.6.12"></script>
<link href="https://unpkg.com/vue-bootstrap-typeahead/dist/VueBootstrapTypeahead.css" rel="stylesheet">
<script src="https://unpkg.com/vue-bootstrap-typeahead"></script>

<script>
    const app = new Vue({
        el: '#vue-app',
        components: {
            VueBootstrapTypeahead
        },
        created() {
            this.initSetadata();
        },
        data: {
            inits: {
                bed: <?php echo json_encode($bed_amounts); ?>,
                surgeon: <?php echo json_encode($surgeon_amounts); ?>,
                anesthesia: <?php echo json_encode($anesthesia_amounts); ?>,
                assistant: <?php echo json_encode($assistant_amounts); ?>,
                consultant: <?php echo json_encode($consultant_amounts); ?>,
                charge: <?php echo json_encode($charge_amounts); ?>,
            },
            tableData: [],
            discount: null,
            advanced: <?php echo $total_advanced ?? 0; ?>,
            commission: null,
            adf: {
                charges: []
            },
            calc: {
                qty: 0,
                bill: 0,
                discount: 0,
                payable: 0,
                net_total: 0,
                advanced: 0,
                due: 0,
                net_commission: 0
            }
        },
        methods: {
            initSetadata() {
                let _this = this;
                Object.keys(_this.inits).forEach(key => {
                    if (_this.inits && _this.inits[key].length > 0) {
                        _this.inits[key].forEach(function(item) {
                            let newData = {
                                id: null,
                                name: "",
                                type: "fixed",
                                code: null,
                                price: "",
                                commissions: 0,
                                quantity: 0,
                                total: 0
                            };
                            var type = item.type == '' ? "" : " (" + item.type + ")";
                            var name = item.name + type + "<br>";
                            var price = item.price;
                            newData.name += name;
                            newData.price += price;
                            newData.quantity += parseFloat(item.qty);
                            newData.total += parseFloat(item.amount);
                            _this.adf.charges.push(newData);
                        });
                    }
                });
                _this.calcAmount();
            },
            updateQty() {
                const data = collect(this.adf.charges).map(function(item) {
                    if (item.type == 'others') {
                        item.total = Math.abs(item.quantity) * parseFloat(item.price);
                    }
                    return item;
                }).all();
                this.adf.charges = data;
                this.calcAmount();
            },
            calcAmount() {
                let _this = this;
                _this.commission = 0;

                Object.keys(_this.calc).forEach(key => {
                    _this.calc[key] = 0;
                });

                const data = collect(_this.adf.charges);
                _this.calc.qty = data.sum('quantity');
                _this.calc.bill = data.sum('total');
                _this.calc.payable = _this.calc.net_total = data.sum('total');
                if (_this.adf.commission_user_id) {
                    let cid = _this.adf.commission_user_id.split(' - ');
                    var user = collect(_this.coms).where('user_id', cid[0]).first();
                    if (data.count() > 0 && user) {
                        data.each(function(item) {
                            _this.calc.net_commission += (parseFloat(item.commissions) * item.quantity);
                        });
                        _this.commission = _this.calc.net_commission;
                    }
                }

                if (_this.discount > 0) {
                    _this.calc.payable -= _this.discount;
                    _this.calc.net_total = _this.calc.payable;
                }
                if (_this.advanced > 0) {
                    _this.calc.net_total -= _this.advanced;
                }
                if (_this.calc.net_total > 0) {
                    _this.calc.due = _this.calc.net_total;
                }
            },
            setDataToTable(data) {
                var exists = collect(this.adf.charges).where('id', data.id).first();

                if (!exists) {
                    var newData = {
                        id: data.id,
                        name: data.name,
                        code: data.code,
                        type: "others",
                        price: parseFloat(data.price),
                        commissions: parseFloat(data.commission),
                        quantity: 1,
                        total: 1 * parseFloat(data.price)
                    };
                    this.adf.charges.push(newData);
                } else {
                    $.toast({
                        text: data.name + ' already added in list',
                        position: 'top-right',
                        loaderBg: '#7a5449',
                        class: 'jq-toast-danger',
                        hideAfter: 3500,
                        stack: 6,
                        showHideTransition: 'fade'
                    });
                }
                this.clearItem();
            }
        }
    });
</script>