<div class="table-wrap">
    <div class="table-responsive">
        <table class="table table-sm text-white">
            <tbody>
                <tr>
                    <td><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></td>
                    <td><?php echo $payment->patient_name; ?></td>
                    <td><?php echo $this->lang->line('patient_id'); ?></td>
                    <td><?php echo $payment->patient_unique_id; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('amount'); ?></td>
                    <td><?php echo $payment->amount; ?></td>
                    <td><?php echo $this->lang->line('date'); ?></td>
                    <td><?php echo date('d/m/Y h:i A', strtotime($payment->payment_date)); ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('status'); ?></td>
                    <td>
                        <?php if ($payment->payment_status == 'complete') { ?>
                            <span class="badge badge-success"><?php echo $this->lang->line('complete'); ?></span>
                        <?php } elseif ($payment->payment_status == 'rejected') { ?>
                            <span class="badge badge-danger"><?php echo $this->lang->line('rejected'); ?></span>
                        <?php } elseif ($payment->payment_status == 'pending') { ?>
                            <span class="badge badge-info"><?php echo $this->lang->line('pending'); ?></span>
                        <?php } else { ?>
                            <span class="badge badge-warning"><?php echo $this->lang->line('cancel'); ?></span>
                        <?php } ?>
                    </td>
                    <td><?php echo $this->lang->line('remark'); ?></td>
                    <td><?php echo $payment->note; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('created_by'); ?></td>
                    <td><?php echo $payment->created_by; ?></td>
                    <td><?php echo $this->lang->line('date'); ?></td>
                    <td><?php echo date('d F, Y h:i A', strtotime($payment->created_at)); ?></td>
                </tr>
                <?php if ($this->session->userdata('role_id') == SUPER_ADMIN) { ?>
                    <tr>
                        <td><?php echo $this->lang->line('modified_by'); ?></td>
                        <td><?php echo $payment->modified_by; ?></td>
                        <td><?php echo $this->lang->line('date'); ?></td>
                        <td><?php echo $payment->modified_by ? date('d F, Y h:i A', strtotime($payment->modified_at)) : ''; ?>
                        </td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>