<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Employee ID Card</title>
    <?php if ($this->global_setting->favicon) { ?>
        <link rel="icon" href="<?php echo UPLOAD_PATH; ?>icon/<?php echo $this->global_setting->favicon; ?>" type="image/x-icon" />
    <?php } else { ?>
        <link rel="icon" href="<?php echo IMG_URL; ?>favicon.ico" type="image/x-icon" />
    <?php } ?>
    <!-- Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .id-card {
            width: 465px;
            height: 300px;
            position: relative;
            background-image: url("<?php echo IMG_URL; ?>card_hcf_blank.png");
            background-size: cover;
            background-position: center;
        }
        
        .id-card-1 {
            width: 465px;
            height: 300px;
            position: relative;
            background-image: url("<?php echo IMG_URL; ?>card_fcf_blank.png");
            background-size: cover;
            background-position: center;
        }
        
        .id-card-2 {
            width: 465px;
            height: 300px;
            position: relative;
            background-image: url("<?php echo IMG_URL; ?>card_ccf_blank.png");
            background-size: cover;
            background-position: center;
        }

        .patient-info {
            margin-top: 122px;
            font-size: 10px;
            color: black;
        }

        .patient-info td {
            padding: 0;
            color: #000;
        }

        .user-info {
            margin-left: 10px;
            margin-top: 30px;
            
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .id {
            position: absolute;
            right: 6px;
            top: -50px;
            font-size: 13px;
            color: #fff;
        }
        .page {
            margin: 0 auto;
        }

        @page {
            size: A4;
            margin: 0;
        }

        @media print {

            html,
            body {
                font-family: Arial, Helvetica, sans-serif;
            }

            .page {
                margin: 0 auto;
                border: initial;
                border-radius: initial;
                min-height: initial;
                box-shadow: initial;
                background: initial;
                page-break-after: always;
            }
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="container d-flex justify-content-center align-items-center" style="height: 100vh;">
        <div class="id-card">
            <div class="col-md-12">
                <table style="margin-left: 33px;" class="patient-info">
                    <tr>
                        <td width="70%">
                            <table>
                                <tr>
                                   
                                    <td width="34%">
                                            <img src="<?php echo UPLOAD_PATH; ?>qr/<?php echo $patient->patient_unique_id; ?>.png" alt="user" width="95%" height="95%">
                                       
                                    </td>
                                    <td width="66%">
                                        <table class="user-info">
                                            <tbody>
                                                <tr>
                                                    <td style="font-size: 13px;">
                                                        <b>Name: <?php echo $patient->name; ?></b>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="font-size: 11px;">Contact: <?php echo $patient->phone ?? '&nbsp;'; ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="font-size: 11px;">Registered On: <?php echo $patient->card_issue_date ? date('d F, Y', strtotime($patient->card_issue_date)) : '&nbsp;'; ?></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                        <td width="30%">&nbsp;</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    
    <div class="page">
        <div class="container d-flex justify-content-center align-items-center" style="height: 100vh;">
        <div class="id-card-1">
            <div class="col-md-12">
                <table style="margin-left: 33px;" class="patient-info">
                    <tr>
                        <td width="70%">
                            <table>
                                <tr>
                                    <td width="34%">
                                        <?php if ($patient->photo) { ?>
                                            <img src="<?php echo UPLOAD_PATH; ?>qr/<?php echo $patient->patient_unique_id; ?>.png" alt="user" width="95%" height="95%">
                                        <?php } elseif ($patient->gender == 'male') { ?>
                                            <img src="<?php echo IMG_URL; ?>male.png" alt="male" width="100%">
                                        <?php } else { ?>
                                            <img src="<?php echo IMG_URL; ?>female.png" alt="female" width="100%">
                                        <?php }  ?>
                                    </td>
                                    <td width="66%">
                                        <table class="user-info">
                                            <tbody>
                                                <tr>
                                                    <td style="font-size: 13px;">
                                                        <b>Name: <?php echo $patient->name; ?></b>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="font-size: 11px;">Contact: <?php echo $patient->phone ?? '&nbsp;'; ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="font-size: 11px;">Registered On: <?php echo $patient->card_issue_date ? date('d F, Y', strtotime($patient->card_issue_date)) : '&nbsp;'; ?></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                        <td width="30%">&nbsp;</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    
    <div class="page">
        <div class="container d-flex justify-content-center align-items-center" style="height: 100vh;">
        <div class="id-card-2">
            <div class="col-md-12">
                <table style="margin-left: 33px;" class="patient-info">
                    <tr>
                        <td width="70%">
                            <table>
                                <tr>
                                    <td width="34%">
                                        <?php if ($patient->photo) { ?>
                                            <img src="<?php echo UPLOAD_PATH; ?>qr/<?php echo $patient->patient_unique_id; ?>.png" alt="user" width="95%" height="95%">
                                        <?php } elseif ($patient->gender == 'male') { ?>
                                            <img src="<?php echo IMG_URL; ?>male.png" alt="male" width="100%">
                                        <?php } else { ?>
                                            <img src="<?php echo IMG_URL; ?>female.png" alt="female" width="100%">
                                        <?php }  ?>
                                    </td>
                                    <td width="66%">
                                        <table class="user-info">
                                            <tbody>
                                                <tr>
                                                    <td style="font-size: 13px;">
                                                        <b>Name: <?php echo $patient->name; ?></b>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="font-size: 11px;">Contact: <?php echo $patient->phone ?? '&nbsp;'; ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="font-size: 11px;">Registered On: <?php echo $patient->card_issue_date ? date('d F, Y', strtotime($patient->card_issue_date)) : '&nbsp;'; ?></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                        <td width="30%">&nbsp;</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
        

        <!-- Bootstrap JS -->
        <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
        <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>

</html>