<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Report.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Report
 * @description     : Manage report.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Report extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Report_Model', 'report', true);
        $this->data['employees'] = $this->report->get_employee_list();
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('manage_report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/index', $this->data);
    }

    /*****************Function collection**********************************
     * @type            : Function
     * @function name   : collection
     * @description     : Load "Collection Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function collection() {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $created_by = $this->input->get('created_by');

            $this->data['collections'] = $this->report->get_collection_list($keyword, $type, $form_date, $to_date, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('collection') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('pharmacy/report/collection', $this->data);
    }

    /*****************Function collection_pdf**********************************
     * @type            : Function
     * @function name   : collection_pdf
     * @description     : Load "Generate Collection Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function collection_pdf() {

        if ($_GET) {
            $keyword = $this->input->get('keyword');
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $created_by = $this->input->get('created_by');

            $this->data['collections'] = $this->report->get_collection_list($keyword, $type, $form_date, $to_date, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['created_by'] = $created_by;
            $this->data['createdby'] = $this->report->get_single('employees', array('user_id' => $created_by, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('pharmacy/report/pdf/collection', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('collection_' . rand() . '.pdf', 'D');
        }
    }


    /*****************Function due**********************************
     * @type            : Function
     * @function name   : due
     * @description     : Load "Due Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function due() {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = $this->input->get('keyword');
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $created_by = $this->input->get('created_by');

            $this->data['dues'] = $this->report->get_due_list($keyword, $type, $form_date, $to_date, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['to_date'] = date('Y/m/d', strtotime($to_date));
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('due') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('pharmacy/report/due', $this->data);
    }

    /*****************Function due_pdf**********************************
     * @type            : Function
     * @function name   : due_pdf
     * @description     : Load "Generate PDF Due Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function due_pdf() {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = $this->input->get('keyword');
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $created_by = $this->input->get('created_by');

            $this->data['dues'] = $this->report->get_due_list($keyword, $type, $form_date, $to_date, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['created_by'] = $created_by;

            $this->data['createdby'] = $this->report->get_single('employees', array('user_id' => $created_by, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('pharmacy/report/pdf/due', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('due_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function rejected**********************************
     * @type            : Function
     * @function name   : rejected
     * @description     : Load "Rejected Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function rejected() {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $created_by = $this->input->get('created_by');

            $this->data['rejecteds'] = $this->report->get_rejected_list($keyword, $type, $form_date, $to_date, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('rejected') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('pharmacy/report/rejected', $this->data);
    }

    /*****************Function rejected_pdf**********************************
     * @type            : Function
     * @function name   : rejected_pdf
     * @description     : Load "Generate PDF Rejected Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function rejected_pdf() {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $created_by = $this->input->get('created_by');

            $this->data['rejecteds'] = $this->report->get_rejected_list($keyword, $type, $form_date, $to_date, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['created_by'] = $created_by;

            $this->data['createdby'] = $this->report->get_single('employees', array('user_id' => $created_by, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('pharmacy/report/pdf/rejected', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('rejected_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function income**********************************
     * @type            : Function
     * @function name   : income
     * @description     : Load "Income Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function income() {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $created_by = $this->input->get('created_by');

            $this->data['incomes'] = $this->report->get_income_list($keyword, $type, $form_date, $to_date, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('income') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('pharmacy/report/income', $this->data);
    }

    /*****************Function income_pdf**********************************
     * @type            : Function
     * @function name   : income_pdf
     * @description     : Load "Generate PDF Income Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function income_pdf() {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $created_by = $this->input->get('created_by');

            $this->data['incomes'] = $this->report->get_income_list($keyword, $type, $form_date, $to_date, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['created_by'] = $created_by;

            $this->data['createdby'] = $this->report->get_single('employees', array('user_id' => $created_by, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('pharmacy/report/pdf/income', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('income_' . rand() . '.pdf', 'D');
        }
    }

    public function get_sale_list($form_date, $to_date, $type, $doctor_id, $created_by) {
        $this->db->select('I.*, 
        SUM(I.total_bill) as total_bill_amount, 
        SUM(I.discount) as total_discount, 
        SUM(I.net_payable) as total_net_payable, 
        SUM(I.advanced) as total_advanced,
        SUM(I.due_amount) as total_due_amount');
        $this->db->from('ipd_invoices AS I');
        $this->db->join('ipd_patients AS IP', 'IP.id = I.ipd_id', 'left');
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('I.commission_user_id', 0);
            $this->db->or_where('I.commission_user_id', NULL);
            $this->db->or_where('I.commission_user_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('I.commission_user_id >', 0);
        }
        if ($doctor_id) {
            $this->db->where('IP.doctor_id', $doctor_id);
        }
        if ($created_by) {
            $this->db->where('I.created_by', $created_by);
        }
        $this->db->where('I.payment_status', 'complete');
        $this->db->group_by('DATE(I.bill_date)');
        $this->db->order_by('DATE(I.bill_date)', 'ASC');
        return $this->db->get()->result();
    }

    /*****************Function statement**********************************
     * @type            : Function
     * @function name   : statement
     * @description     : Load "Collection Statement Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function statement() {

        check_permission(VIEW);

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('statement') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('pharmacy/report/statement', $this->data);
    }

    /*****************Function sales**********************************
     * @type            : Function
     * @function name   : sales
     * @description     : Load "Sales Statement Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function sales() {

        check_permission(VIEW);

        if ($_GET) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $type = $this->input->get('type');
            $created_by = $this->input->get('created_by');

            $this->data['sales'] = $this->report->get_sale_list($form_date, $to_date, $type, $created_by);
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['type'] = $type;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('sales') . ' ' . $this->lang->line('medicine') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('pharmacy/report/sales', $this->data);
    }

    /*****************Function sales_pdf**********************************
     * @type            : Function
     * @function name   : sales_pdf
     * @description     : Load "Generate PDF Sales Summary Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function sales_pdf() {

        check_permission(VIEW);

        if ($_GET) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $type = $this->input->get('type');
            $created_by = $this->input->get('created_by');

            $this->data['sales'] = $this->report->get_sale_list($form_date, $to_date, $type, $created_by);
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['type'] = $type;
            $this->data['created_by'] = $created_by;

            $this->data['createdby'] = $this->report->get_single('employees', array('user_id' => $created_by, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('pharmacy/report/pdf/sales', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('sales_summary_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function purchase**********************************
     * @type            : Function
     * @function name   : purchase
     * @description     : Load "Purchase Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function purchase() {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $manufacturer_id = $this->input->get('manufacturer_id');
            $created_by = $this->input->get('created_by');

            $this->data['purchases'] = $this->report->get_purchase_list($keyword, $type, $form_date, $to_date, $manufacturer_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['manufacturer_id'] = $manufacturer_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['manufacturers'] = $this->report->get_list('manufacturers', array('status' => 1));
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('purchase') . ' ' . $this->lang->line('medicine') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('pharmacy/report/purchase', $this->data);
    }

    /*****************Function purchase_pdf**********************************
     * @type            : Function
     * @function name   : purchase_pdf
     * @description     : Load "Generate PDF Purchase Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function purchase_pdf() {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $manufacturer_id = $this->input->get('manufacturer_id');
            $created_by = $this->input->get('created_by');

            $this->data['purchases'] = $this->report->get_purchase_list($keyword, $type, $form_date, $to_date, $manufacturer_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['manufacturer_id'] = $manufacturer_id;
            $this->data['created_by'] = $created_by;

            $this->data['manufacturer'] = $this->report->get_single('manufacturers', array('id' => $manufacturer_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('pharmacy/report/pdf/purchase', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('purchase_' . rand() . '.pdf', 'D');
        }
    }


    /*****************Function wastage**********************************
     * @type            : Function
     * @function name   : wastage
     * @description     : Load "Wastage Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function wastage() {

        check_permission(VIEW);

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('wastage') . ' ' . $this->lang->line('medicine') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('pharmacy/report/wastage', $this->data);
    }

    /*****************Function refund**********************************
     * @type            : Function
     * @function name   : refund
     * @description     : Load "Refund Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function refund() {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $manufacturer_id = $this->input->get('manufacturer_id');
            $created_by = $this->input->get('created_by');

            $this->data['refunds'] = $this->report->get_refund_list($keyword, $type, $form_date, $to_date, $manufacturer_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['manufacturer_id'] = $manufacturer_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['manufacturers'] = $this->report->get_list('manufacturers', array('status' => 1));
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('refund') . ' ' . $this->lang->line('medicine') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('pharmacy/report/refund', $this->data);
    }

    /*****************Function refund_pdf**********************************
     * @type            : Function
     * @function name   : refund_pdf
     * @description     : Load "Generate PDF Refund Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function refund_pdf() {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $manufacturer_id = $this->input->get('manufacturer_id');
            $created_by = $this->input->get('created_by');

            $this->data['refunds'] = $this->report->get_refund_list($keyword, $type, $form_date, $to_date, $manufacturer_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['manufacturer_id'] = $manufacturer_id;
            $this->data['created_by'] = $created_by;

            $this->data['manufacturer'] = $this->report->get_single('manufacturers', array('id' => $manufacturer_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('pharmacy/report/pdf/refund', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('refund_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function stock**********************************
     * @type            : Function
     * @function name   : stock
     * @description     : Load "Stock Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function stock() {

        check_permission(VIEW);

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('stock') . ' ' . $this->lang->line('medicine') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('pharmacy/report/stock', $this->data);
    }

    /*****************Function medicine**********************************
     * @type            : Function
     * @function name   : medicine
     * @description     : Load "Medicine Sale Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function medicine() {

        check_permission(VIEW);

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('medicine') . ' ' . $this->lang->line('sale') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('pharmacy/report/medicine', $this->data);
    }

    /*****************Function profit**********************************
     * @type            : Function
     * @function name   : profit
     * @description     : Load "Medicine Profit Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function profit() {

        check_permission(VIEW);

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('medicine') . ' ' . $this->lang->line('profit') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('pharmacy/report/profit', $this->data);
    }
}
