<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Report_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_employee_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST, PHARMACIST));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST, PHARMACIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_collection_list($keyword, $type, $form_date, $to_date, $created_by) {
        $this->db->select('MP.*, MI.custom_invoice_id, MI.customer_id, MI.walking, MI.customer_name, MI.bill_date, MI.total_bill, P.patient_unique_id, P.name as customer, P.phone, C.name as created_by');
        $this->db->from('medicine_invoice_payments AS MP');
        $this->db->join('medicine_invoices AS MI', 'MI.id = MP.invoice_id ', 'left');
        $this->db->join('patients AS P', 'P.user_id = MI.customer_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = MP.created_by', 'left');
        if ($keyword) {
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
            $this->db->or_like('MI.customer_name', $keyword, 'both');
        }
        if ($type == 1) {
            $this->db->where('MI.walking', 1);
        }
        if ($type == 2) {
            $this->db->where('MI.customer_id >', 0);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(MP.payment_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($created_by) {
            $this->db->where('MP.created_by', $created_by);
        }
        $this->db->where('MI.payment_status', 'complete');
        $this->db->order_by('MP.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_due_list($keyword, $type, $form_date, $to_date, $created_by) {
        $this->db->select('I.*, P.patient_unique_id, P.name as customer, P.phone, C.name as created_by');
        $this->db->from('medicine_invoices AS I');
        $this->db->join('patients AS P', 'P.user_id = I.customer_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = I.created_by', 'left');
        if ($keyword) {
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
        }
        if ($type == 1) {
            $this->db->where('I.walking', 1);
        }
        if ($type == 2) {
            $this->db->where('I.customer_id >', 0);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($created_by) {
            $this->db->where('I.created_by', $created_by);
        }
        $this->db->where('I.paid_status', 'unpaid');
        $this->db->where('I.payment_status', 'complete');
        $this->db->order_by('I.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_rejected_list($keyword, $type, $form_date, $to_date, $created_by) {
        $this->db->select('I.*, P.patient_unique_id, P.name as customer, P.phone, C.name as created_by');
        $this->db->from('medicine_invoices AS I');
        $this->db->join('patients AS P', 'P.user_id = I.customer_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = I.created_by', 'left');
        if ($keyword) {
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
        }
        if ($type == 1) {
            $this->db->where('I.walking', 1);
        }
        if ($type == 2) {
            $this->db->where('I.customer_id >', 0);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($created_by) {
            $this->db->where('I.created_by', $created_by);
        }
        $this->db->where('I.payment_status', 'rejected');
        $this->db->order_by('I.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_income_list($keyword, $type, $form_date, $to_date, $created_by) {
        $this->db->select('I.*, P.patient_unique_id, P.name as customer, P.phone, C.name as created_by');
        $this->db->from('medicine_invoices AS I');
        $this->db->join('patients AS P', 'P.user_id = I.customer_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = I.created_by', 'left');
        if ($keyword) {
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
        }
        if ($type == 1) {
            $this->db->where('I.walking', 1);
        }
        if ($type == 2) {
            $this->db->where('I.customer_id >', 0);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($created_by) {
            $this->db->where('I.created_by', $created_by);
        }
        $this->db->where('I.payment_status', 'complete');
        $this->db->order_by('I.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_sale_list($form_date, $to_date, $type, $created_by) {
        $this->db->select('I.*, 
        SUM(I.total_bill) as total_bill_amount, 
        SUM(I.discount) as total_discount, 
        SUM(I.net_payable) as total_net_payable, 
        SUM(I.advanced) as total_advanced,
        SUM(I.due_amount) as total_due_amount');
        $this->db->from('medicine_invoices AS I');
        $this->db->join('patients AS P', 'P.user_id = I.customer_id', 'left');
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($type == 1) {
            $this->db->where('I.walking', 1);
        }
        if ($type == 2) {
            $this->db->where('I.customer_id >', 0);
        }
        if ($created_by) {
            $this->db->where('I.created_by', $created_by);
        }
        $this->db->where('I.payment_status', 'complete');
        $this->db->group_by('DATE(I.bill_date)');
        $this->db->order_by('DATE(I.bill_date)', 'ASC');
        return $this->db->get()->result();
    }

    public function get_purchase_list($keyword, $type, $form_date, $to_date, $manufacturer_id, $created_by) {
        $this->db->select('MP.*, M.name as manufacturer, C.name as created_by');
        $this->db->from('medicine_purchases AS MP');
        $this->db->join('manufacturers AS M', 'M.id = MP.manufacturer_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = MP.created_by', 'left');
        if ($keyword) {
            $this->db->like('M.phone', $keyword);
            $this->db->or_like('M.name', $keyword, 'both');
            $this->db->or_like('MP.invoice_no', $keyword, 'both');
        }
        if ($type == 1) {
            $this->db->where('MP.payment_type', 'cash');
        }
        if ($type == 2) {
            $this->db->where('MP.payment_type', 'credit');
        }
        if ($type == 3) {
            $this->db->where('MP.payment_type', 'due');
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(MP.purchase_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($manufacturer_id) {
            $this->db->where('MP.manufacturer_id', $manufacturer_id);
        }
        if ($created_by) {
            $this->db->where('MP.created_by', $created_by);
        }
        $this->db->where('MP.payment_status', 'complete');
        $this->db->order_by('MP.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_refund_list($keyword, $type, $form_date, $to_date, $manufacturer_id, $created_by) {
        $this->db->select('MR.*, MI.walking, MI.customer_id, MI.customer_name, P.patient_unique_id, P.name as customer, M.name as manufacturer, C.name as created_by');
        $this->db->from('medicine_refunds AS MR');
        $this->db->join('medicine_invoices AS MI', 'MI.id = MR.sale_invoice_id', 'left');
        $this->db->join('patients AS P', 'P.user_id = MI.customer_id', 'left');
        $this->db->join('medicine_purchases AS MP', 'MP.id = MR.purchase_invoice_id', 'left');
        $this->db->join('manufacturers AS M', 'M.id = MP.manufacturer_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = MR.created_by', 'left');
        if ($keyword) {
            $this->db->like('M.phone', $keyword);
            $this->db->or_like('M.name', $keyword, 'both');
            $this->db->or_like('MR.custom_invoice_id', $keyword, 'both');
        }
        if ($type == 1) {
            $this->db->where('MR.return_type', '1');
        }
        if ($type == 2) {
            $this->db->where('MR.return_type', '2');
        }
        if ($type == 3) {
            $this->db->where('MR.return_type', '3');
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(MR.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($manufacturer_id) {
            $this->db->where('M.id', $manufacturer_id);
        }
        if ($created_by) {
            $this->db->where('MR.created_by', $created_by);
        }
        $this->db->where('MR.payment_status', 'complete');
        $this->db->order_by('MR.id', 'ASC');
        return $this->db->get()->result();
    }
}
