<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('medicine'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_medicine'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('pharmacy/medicine/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(EDIT, 'pharmacy', 'medicine')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-medkit font-30 mr-10"></i>
                            <?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('medicine'); ?>
                        </h6>
                    <?php } ?>

                    <div class="align-items-center">
                        <?php if (has_permission(EDIT, 'pharmacy', 'medicine')) { ?>
                            <button type="button" class="btn btn-teal btn-xs" data-toggle="modal" data-target="#addGenericModal">
                                <i class="fa fa-ravelry  font-12 mr-5"></i>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('generic'); ?>
                            </button>
                        <?php } ?>
                        <?php if (has_permission(VIEW, 'pharmacy', 'medicine')) { ?>
                            <a href="<?php echo site_url('pharmacy/medicine'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('medicine_list'); ?>
                            </a>
                        <?php } ?>
                    </div>
                </div>

                <?php echo form_open_multipart(site_url('pharmacy/medicine/edit/' . $medicine->id), array('name' => 'edit', 'id' => 'edit', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-4 mb-10">
                            <label for="type_id"><?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control select2" name="type_id" id="type_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($types as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($medicine->type_id) && $medicine->type_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="type_id" class="form-text text-muted">
                                <?php echo form_error('type_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="category_id"><?php echo $this->lang->line('category'); ?></label>
                            <select class="form-control select2" name="category_id" id="category_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($categories as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($medicine->category_id) && $medicine->category_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="category_id" class="form-text text-muted">
                                <?php echo form_error('category_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="manufacturer_id"><?php echo $this->lang->line('manufacturer'); ?></label>
                            <select class="form-control select2" name="manufacturer_id" id="manufacturer_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($manufacturers as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($medicine->manufacturer_id) && $medicine->manufacturer_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="manufacturer_id" class="form-text text-muted">
                                <?php echo form_error('manufacturer_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="generic_id"><?php echo $this->lang->line('generic'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <select class="form-control select2" name="generic_id" id="generic_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($generics as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($medicine->generic_id) && $medicine->generic_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="generic_id" class="form-text text-muted">
                                <?php echo form_error('generic_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="medicine_name"><?php echo $this->lang->line('medicine'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <input type="text" class="form-control" name="medicine_name" id="medicine_name" value="<?php echo isset($medicine->medicine_name) ?  $medicine->medicine_name : ''; ?>" placeholder="<?php echo $this->lang->line('medicine'); ?> <?php echo $this->lang->line('name'); ?>">
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="medicine_name" class="form-text text-muted">
                                <?php echo form_error('medicine_name'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="rack_no"><?php echo $this->lang->line('rack_no'); ?></label>
                            <input type="text" class="form-control" name="rack_no" id="rack_no" value="<?php echo isset($medicine->rack_no) ?  $medicine->rack_no : ''; ?>" placeholder="<?php echo $this->lang->line('rack_no'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="mrp"><?php echo $this->lang->line('mrp'); ?></label>
                            <input type="text" class="form-control" name="mrp" id="mrp" value="<?php echo isset($medicine->mrp) ?  $medicine->mrp : ''; ?>" placeholder="<?php echo $this->lang->line('mrp'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="purchase_price"><?php echo $this->lang->line('purchase'); ?> <?php echo $this->lang->line('price'); ?></label>
                            <input type="text" class="form-control" name="purchase_price" id="purchase_price" value="<?php echo isset($medicine->purchase_price) ?  $medicine->purchase_price : ''; ?>" placeholder="<?php echo $this->lang->line('purchase'); ?> <?php echo $this->lang->line('price'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="sell_price"><?php echo $this->lang->line('sell'); ?> <?php echo $this->lang->line('price'); ?></label>
                            <input type="text" class="form-control" name="sell_price" id="sell_price" value="<?php echo isset($medicine->sell_price) ?  $medicine->sell_price : ''; ?>" placeholder="<?php echo $this->lang->line('sell'); ?> <?php echo $this->lang->line('price'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="whole_sale_price"><?php echo $this->lang->line('wholesale'); ?> <?php echo $this->lang->line('price'); ?></label>
                            <input type="text" class="form-control" name="whole_sale_price" id="whole_sale_price" value="<?php echo isset($medicine->whole_sale_price) ?  $medicine->whole_sale_price : ''; ?>" placeholder="<?php echo $this->lang->line('wholesale'); ?> <?php echo $this->lang->line('price'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="strength"><?php echo $this->lang->line('strength'); ?></label>
                            <input type="text" class="form-control" name="strength" id="strength" value="<?php echo isset($medicine->strength) ?  $medicine->strength : ''; ?>" placeholder="<?php echo $this->lang->line('strength'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="unit_id"><?php echo $this->lang->line('unit'); ?></label>
                            <select class="form-control select2" name="unit_id" id="unit_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($units as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($medicine->unit_id) && $medicine->unit_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="unit_id" class="form-text text-muted">
                                <?php echo form_error('unit_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="minimum_stock"><?php echo $this->lang->line('minimum_stock'); ?></label>
                            <input type="number" class="form-control" name="minimum_stock" id="minimum_stock" value="<?php echo isset($medicine->minimum_stock) ?  $medicine->minimum_stock : '5'; ?>" placeholder="<?php echo $this->lang->line('minimum_stock'); ?>">
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="photo"><?php echo $this->lang->line('photo'); ?></label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                        <input type="file" name="photo">
                                        <input type="hidden" name="prev_photo" id="prev_photo" value="<?php echo $medicine->photo; ?>" />
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-1 mb-10">
                            <div class="avatar">
                                <?php if ($medicine->photo != '') { ?>
                                    <img class="avatar-img rounded" src="<?php echo UPLOAD_PATH; ?>medicine-photo/<?php echo $medicine->photo; ?>" alt="<?php echo $medicine->medicine_name; ?>" />
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-2 mt-40">
                            <div class="custom-control custom-checkbox checkbox-cyan">
                                <input type="checkbox" class="custom-control-input" name="status" id="status" value="1" <?php echo $medicine->status ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="status"><?php echo $this->lang->line('status'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('note'); ?></span>
                                </div>
                                <textarea class="form-control" name="note" id="note" aria-label="<?php echo $this->lang->line('note'); ?>"><?php echo isset($medicine->note) ?  $medicine->note : ''; ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="id" value="<?php echo $medicine->id; ?>">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('pharmacy/medicine'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Add Generic Modal-->
<div class="modal fade" id="addGenericModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalForms" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('generic'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="addGenericForm" enctype="multipart/form-data" method="POST" action="<?php echo site_url('pharmacy/medicine/addGeneric'); ?>">
                <div class="modal-body">
                    <div class="form-row">
                        <div class="col-md-6 mb-10">
                            <label for="name"><?php echo $this->lang->line('name'); ?> <span class="required">*</span></label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($name) ?  $name : ''; ?>" placeholder="<?php echo $this->lang->line('name'); ?>" required>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="remark"><?php echo $this->lang->line('remark'); ?></label>
                            <input type="text" class="form-control" name="note" id="remark" value="<?php echo isset($note) ?  $note : ''; ?>" placeholder="<?php echo $this->lang->line('remark'); ?>">
                        </div>
                    </div>
                </div>
                <div class="modal-footer pt-0">
                    <div class="button-list">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                        <button class="btn btn-gradient-primary" type="submit" id="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>


<script type="text/javascript">
    $(document).ready(function(e) {
        $("#addGenericForm").on('submit', (function(e) {
            e.preventDefault();
            $.ajax({
                url: '<?php echo base_url('pharmacy/medicine/addGeneric'); ?>',
                type: "POST",
                data: new FormData(this),
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                success: function(data) {
                    if (data.status == "failed") {
                        var message = "";
                        $.each(data.error, function(index, value) {
                            message += value;
                        });
                        $.toast({
                            text: message,
                            position: 'top-right',
                            loaderBg: '#7a5449',
                            class: 'jq-toast-danger',
                            hideAfter: 3500,
                            stack: 6,
                            showHideTransition: 'fade'
                        });

                    } else {
                        $.toast({
                            text: data.message,
                            position: 'top-right',
                            loaderBg: '#7a5449',
                            class: 'jq-toast-primary',
                            hideAfter: 3500,
                            stack: 6,
                            showHideTransition: 'fade'
                        });
                        var data = {
                            id: data.id,
                            text: data.name,
                        };
                        var newOption = new Option(data.text, data.id, false, false);
                        $('#generic_id').append(newOption).trigger('change');
                        $("#addGenericModal").modal('hide');
                        $('#addGenericModal').find('form')[0].reset();
                    }
                }
            });
        }));
    });
</script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>

<script>
    $(".select2").select2();
</script>