<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('refund'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_refund'); ?>
        </h4>

        <div class="align-items-center">
            <?php if (has_permission(VIEW, 'pharmacy', 'purchase')) { ?>
                <a href="<?php echo site_url('pharmacy/purchase'); ?>" class="btn btn-xs btn-info">
                    <i class="fa fa-cart-plus font-12 mr-5"></i>
                    <?php echo $this->lang->line('purchase'); ?>
                </a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'pharmacy', 'stock')) { ?>
                <a href="<?php echo site_url('pharmacy/stock'); ?>" class="btn btn-xs btn-success">
                    <i class="fa fa-bar-chart font-12 mr-5"></i>
                    <?php echo $this->lang->line('stock'); ?>
                </a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'pharmacy', 'sale')) { ?>
                <a href="<?php echo site_url('pharmacy/sale'); ?>" class="btn btn-xs btn-danger">
                    <i class="fa fa-balance-scale font-12 mr-5"></i>
                    <?php echo $this->lang->line('sale'); ?>
                </a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-4 -->
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'pharmacy', 'refund')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user font-30 mr-10"></i>
                            <?php echo $this->lang->line('customer'); ?> <?php echo $this->lang->line('refund'); ?>
                        </h6>
                    <?php } ?>

                    <?php if (has_permission(VIEW, 'pharmacy', 'refund')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('pharmacy/refund/customer'); ?>" class="btn btn-xs btn-success">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('refund'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('pharmacy/refund/customer_search'), array('name' => 'search', 'id' => 'search'), ''); ?>
                    <div class="form-row">
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('invoice_no'); ?></span>
                                </div>
                                <input type="text" class="form-control" name="invoice_no" id="invoice_no" value="<?php echo isset($invoice_no) ?  $invoice_no : ''; ?>" autocomplete="off" placeholder="<?php echo $this->lang->line('invoice_no'); ?>" required>
                                <div class="input-group-append">
                                    <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('search'); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <!-- col-lg-4 -->
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'pharmacy', 'refund')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-industry font-30 mr-10"></i>
                            <?php echo $this->lang->line('manufacturer'); ?>
                        </h6>
                    <?php } ?>

                    <?php if (has_permission(VIEW, 'pharmacy', 'refund')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('pharmacy/refund/manufacturer'); ?>" class="btn btn-xs btn-info">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('manufacturer'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('#'), array('name' => 'search', 'id' => 'search'), ''); ?>
                    <div class="form-row">
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('invoice_no'); ?></span>
                                </div>
                                <input type="text" class="form-control" name="invoice_no" id="invoice_no" value="<?php echo isset($invoice_no) ?  $invoice_no : ''; ?>" autocomplete="off" placeholder="<?php echo $this->lang->line('invoice_no'); ?>" required>
                                <div class="input-group-append">
                                    <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('search'); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <!-- col-lg-4 -->
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'pharmacy', 'refund')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-ban font-30 mr-10"></i>
                            <?php echo $this->lang->line('wastage'); ?> <?php echo $this->lang->line('refund'); ?>
                        </h6>
                    <?php } ?>

                    <?php if (has_permission(VIEW, 'pharmacy', 'refund')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('pharmacy/refund/wastage'); ?>" class="btn btn-xs btn-danger">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('wastage'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('#'), array('name' => 'search', 'id' => 'search'), ''); ?>
                    <div class="form-row">
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('invoice_no'); ?></span>
                                </div>
                                <input type="text" class="form-control" name="invoice_no" id="invoice_no" value="<?php echo isset($invoice_no) ?  $invoice_no : ''; ?>" autocomplete="off" placeholder="<?php echo $this->lang->line('invoice_no'); ?>" required>
                                <div class="input-group-append">
                                    <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('search'); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->