<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="d-flex">
            <?php if (has_permission(ADD, 'radiology', 'report')) { ?>
                <a href="<?php echo site_url('radiology/report/create'); ?>" class="btn btn-primary btn-xs mr-10"><i class="fa fa-plus"></i> <?php echo $this->lang->line('create'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>

            <?php if (has_permission(VIEW, 'radiology', 'report')) { ?>
                <a href="<?php echo site_url('radiology/report'); ?>" class="btn btn-success btn-xs mr-10"><i class="fa fa-flask"></i> <?php echo $this->lang->line('report'); ?> <?php echo $this->lang->line('list'); ?></a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <div class="col-lg-5">
            <div class="card mb-0 mt-0">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'radiology', 'report')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-flask font-30 mr-10"></i>
                            <?php echo $this->lang->line('test'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('department'); ?></th>
                                        <th><?php echo $this->lang->line('name'); ?></th>
                                        <th><?php echo $this->lang->line('sample_collect'); ?></th>
                                        <th><?php echo $this->lang->line('delivery'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $count = 1;
                                    if (isset($tests) && !empty($tests)) { ?>
                                        <?php foreach ($tests as $obj) {
                                            $report = $this->report->get_single('diagnostic_reports', array('invoice_id' => $obj->invoice_id, 'investagation_id' => $obj->investagation_id));
                                        ?>
                                            <tr>
                                                <td><?php echo $count++; ?></td>
                                                <td><?php echo $obj->department; ?></td>
                                                <td><?php echo $obj->test_name; ?></td>
                                                <td><?php echo @$report->sample_collect ? '<span class="badge badge-success">' . $this->lang->line('yes') . '</span>' : '<span class="badge badge-danger">' . $this->lang->line('no') . '</span>'; ?></td>
                                                <td><?php echo @$report->delivery_status == 1 ? '<span class="badge badge-primary">' . $this->lang->line('yes') . '</span>' : '<span class="badge badge-danger">' . $this->lang->line('no') . '</span>'; ?></td>
                                            </tr>
                                        <?php }  ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="5"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- / col-lg-7 -->
        <div class="col-lg-7">
            <div class="card mb-0 mt-0">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'radiology', 'report')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-flask font-30 mr-10"></i>
                            <?php echo $this->lang->line('report'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('id'); ?></th>
                                        <th><?php echo $this->lang->line('name'); ?></th>
                                        <th><?php echo $this->lang->line('date'); ?></th>
                                        <th><?php echo $this->lang->line('status'); ?></th>
                                        <th width="15%"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $count = 1;
                                    if (isset($reports) && !empty($reports)) { ?>
                                        <?php foreach ($reports as $obj) { ?>
                                            <tr>
                                                <td><?php echo $obj->custom_report_id; ?></td>
                                                <td><?php echo $obj->test_name; ?></td>
                                                <td><?php echo date('Y-d-m, h:i A', strtotime($obj->created_at)); ?></td>
                                                <td><?php echo $obj->template_status ? '<span class="badge badge-success">' . $this->lang->line('complete') . '</span>' : '<span class="badge badge-danger">' . $this->lang->line('pending') . '</span>'; ?></td>
                                                <td>
                                                    <?php if (has_permission(VIEW, 'radiology', 'report')) { ?>
                                                        <?php if ($obj->template_status) { ?>
                                                            <button class="btn btn-orange btn-xs" onclick="getPrint('<?php echo $obj->report_id; ?>')" type="button">
                                                                <i class="fa fa-print"></i>
                                                            </button>
                                                        <?php } ?>
                                                    <?php } ?>
                                                    <?php if (has_permission(VIEW, 'radiology', 'report')) { ?>
                                                        <?php if ($obj->template_id > 0 && $obj->template_status) { ?>
                                                            <a class="btn btn-info btn-xs" href="<?php echo site_url('radiology/report/single/' . $obj->report_id); ?>"><i class="fa fa-eye"></i></a>
                                                        <?php } ?>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                        <?php }  ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="5"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- /Container -->

<script>
    function getPrint(report_id) {
        var base_url = '<?php echo base_url() ?>';
        $.ajax({
            url: base_url + 'radiology/report/print',
            type: 'POST',
            data: {
                report_id: report_id,
            },
            success: function(result) {
                $("#testdata").html(result);
                popup(result);
            }
        });
    }

    function popup(data) {
        var base_url = '<?php echo base_url() ?>';
        var frame1 = $('<iframe />');
        frame1[0].name = "frame1";
        frame1.css({
            "position": "absolute",
            "top": "-1000000px"
        });
        $("body").append(frame1);
        var frameDoc = frame1[0].contentWindow ? frame1[0].contentWindow : frame1[0].contentDocument.document ? frame1[0].contentDocument.document : frame1[0].contentDocument;
        frameDoc.document.open();
        //Create a new HTML document.
        frameDoc.document.write('<html>');
        frameDoc.document.write('<head>');
        frameDoc.document.write('<title></title>');

        frameDoc.document.write('</head>');
        frameDoc.document.write('<body>');
        frameDoc.document.write(data);
        frameDoc.document.write('</body>');
        frameDoc.document.write('</html>');
        frameDoc.document.close();
        setTimeout(function() {
            window.frames["frame1"].focus();
            window.frames["frame1"].print();
            frame1.remove();
            //window.location.reload(true);
        }, 500);
        return true;
    }
</script>