<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Attendance_Model extends MY_Model
{

    function __construct()
    {
        parent::__construct();
    }

    public function get_employee_list()
    {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') != SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, PATHOLOGIST, RADIOLOGIST, NURSE, RECEPTIONIST, STAFF, MARKETING, PHARMACIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_created_by_list()
    {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_attendance_employee_list($department_id, $designation_id, $shift_id, $user_id)
    {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.employee_type', 'staff');
        if ($department_id) {
            $this->db->where('E.department_id', $department_id);
        }
        if ($designation_id) {
            $this->db->where('E.designation_id', $designation_id);
        }
        if ($shift_id) {
            $this->db->where('E.shift_id', $shift_id);
        }
        if ($user_id) {
            $this->db->where('E.user_id', $user_id);
        }
        $this->db->where('E.status', '1');
        $this->db->order_by('U.device_id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_daily_attendance_list($type, $attendance_status, $form_date, $to_date, $user_id, $department_id, $designation_id, $shift_id, $created_by)
    {
        $this->db->select('A.*, E.name, D.name as designation, S.name as shift');
        $this->db->from('attendances AS A');
        $this->db->join('employees AS E', 'E.user_id = A.user_id', 'left');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        $this->db->join('shifts AS S', 'S.id = A.shift_id', 'left');
        $this->db->join('users AS U', 'U.id = A.user_id', 'left');
        if ($type == 1) {
            $this->db->where('A.early_leaving >', 0);
        }
        if ($type == 2) {
            $this->db->where('A.late >', 0);
        }
        if ($attendance_status) {
            $this->db->where('A.attendance_status', $attendance_status);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(A.date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($user_id) {
            $this->db->where('A.user_id', $user_id);
        }
        if ($department_id) {
            $this->db->where('E.department_id', $department_id);
        }
        if ($designation_id) {
            $this->db->where('E.designation_id', $designation_id);
        }
        if ($shift_id) {
            $this->db->where('A.shift_id', $shift_id);
        }
        if ($created_by) {
            $this->db->where('A.created_by', $created_by);
        }
        $this->db->order_by('U.device_id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_not_in_office_attendance_list($user_id, $department_id, $designation_id, $shift_id, $created_by)
    {
        $this->db->select('E.*, DP.name as department, D.name as designation, U.device_id, S.name as shift');
        $this->db->from('employees AS E');
        $this->db->join('departments AS DP', 'DP.id = E.department_id', 'left');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        $this->db->join('shifts AS S', 'S.id = E.shift_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        if ($user_id) {
            $this->db->where('E.user_id', $user_id);
        }
        if ($department_id) {
            $this->db->where('E.department_id', $department_id);
        }
        if ($designation_id) {
            $this->db->where('E.designation_id', $designation_id);
        }
        if ($shift_id) {
            $this->db->where('E.shift_id', $shift_id);
        }
        if ($created_by) {
            $this->db->where('E.created_by', $created_by);
        }
        $this->db->where('E.employee_type', 'staff');
        $this->db->order_by('U.device_id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_monthly_attendance_list($attendance_date, $shift_id, $user_id)
    {
        $this->db->select('A.*');
        $this->db->from('attendances AS A');
        if ($attendance_date) {
            $this->db->where("DATE(A.date)", $attendance_date);
        }
        if ($shift_id) {
            $this->db->where('A.shift_id', $shift_id);
        }
        if ($user_id) {
            $this->db->where('A.user_id', $user_id);
        }
        return $this->db->get()->result();
    }

    public function get_total_present_count($user_id, $year, $month)
    {
        $this->db->select('COUNT(A.user_id) AS total_present');
        $this->db->from('attendances AS A');
        $this->db->where('A.attendance_status', 'p');
        $this->db->where('A.user_id', $user_id);
        $this->db->where("YEAR(A.date)", $year);
        $this->db->where("MONTH(A.date)", $month);
        return $this->db->get()->row()->total_present;
    }

    public function get_late_attendance_list($form_date, $to_date, $user_id, $department_id, $designation_id, $shift_id, $created_by)
    {
        $this->db->select('A.*, E.name, D.name as designation, S.name as shift, S.in_time, S.out_time');
        $this->db->from('attendances AS A');
        $this->db->join('employees AS E', 'E.user_id = A.user_id', 'left');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        $this->db->join('shifts AS S', 'S.id = A.shift_id', 'left');
        $this->db->join('users AS U', 'U.id = A.user_id', 'left');
        if ($form_date && $to_date) {
            $this->db->where("DATE(A.date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($user_id) {
            $this->db->where('A.user_id', $user_id);
        }
        if ($department_id) {
            $this->db->where('E.department_id', $department_id);
        }
        if ($designation_id) {
            $this->db->where('E.designation_id', $designation_id);
        }
        if ($shift_id) {
            $this->db->where('A.shift_id', $shift_id);
        }
        if ($created_by) {
            $this->db->where('A.created_by', $created_by);
        }
        $this->db->where("TIME(A.late) >", 0);
        $this->db->order_by('U.device_id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_early_leaving_attendance_list($form_date, $to_date, $user_id, $department_id, $designation_id, $shift_id, $created_by)
    {
        $this->db->select('A.*, E.name, D.name as designation, S.name as shift, S.in_time, S.out_time');
        $this->db->from('attendances AS A');
        $this->db->join('employees AS E', 'E.user_id = A.user_id', 'left');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        $this->db->join('shifts AS S', 'S.id = A.shift_id', 'left');
        $this->db->join('users AS U', 'U.id = A.user_id', 'left');
        if ($form_date && $to_date) {
            $this->db->where("DATE(A.date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($user_id) {
            $this->db->where('A.user_id', $user_id);
        }
        if ($department_id) {
            $this->db->where('E.department_id', $department_id);
        }
        if ($designation_id) {
            $this->db->where('E.designation_id', $designation_id);
        }
        if ($shift_id) {
            $this->db->where('A.shift_id', $shift_id);
        }
        if ($created_by) {
            $this->db->where('A.created_by', $created_by);
        }
        $this->db->where("TIME(A.early_leaving) >", 0);
        $this->db->order_by('U.device_id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_summary_attendance_list($department_id)
    {
        $this->db->select('D.*');
        $this->db->from('departments AS D');
        if ($department_id) {
            $this->db->where_in('D.id', $department_id);
        }
        $this->db->order_by('D.sort_by', 'ASC');
        return $this->db->get()->result();
    }

    public function get_summary_count_attendance($department_id, $date, $attendance_status, $type)
    {
        $this->db->select('A.*');
        $this->db->from('attendances AS A');
        $this->db->join('employees AS E', 'E.user_id = A.user_id', 'left');
        if ($department_id) {
            $this->db->where_in('E.department_id', $department_id);
        }
        if ($date) {
            $this->db->where("DATE(A.date)", $date);
        }
        if ($attendance_status) {
            $this->db->where('A.attendance_status', $attendance_status);
        }
        if ($type == 'late') {
            $this->db->where("TIME(A.late) >", 0);
        }
        if ($type == 'early_leaving') {
            $this->db->where("TIME(A.early_leaving) >", 0);
        }
        return $this->db->get()->num_rows();
    }

    public function get_leave_list($leave_status, $leave_type_id, $form_date, $to_date, $user_id, $department_id, $designation_id, $approved)
    {
        $this->db->select('L.*, LT.type, E.name, D.name as designation, M.name as modified_by');
        $this->db->from('leaves AS L');
        $this->db->join('leave_types AS LT', 'LT.id = L.leave_type_id', 'left');
        $this->db->join('employees AS E', 'E.user_id = L.user_id', 'left');
        $this->db->join('employees AS M', 'M.user_id = L.modified_by', 'left');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        if ($leave_status) {
            $this->db->where('L.leave_status', $leave_status);
        }
        if ($leave_type_id) {
            $this->db->where('L.leave_type_id', $leave_type_id);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(L.leave_from) AND DATE(L.leave_to) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($user_id) {
            $this->db->where('L.user_id', $user_id);
        }
        if ($department_id) {
            $this->db->where('E.department_id', $department_id);
        }
        if ($designation_id) {
            $this->db->where('E.designation_id', $designation_id);
        }
        if ($approved) {
            $this->db->where('L.modified_by', $approved);
        }
        $this->db->order_by('L.id', 'DESC');
        return $this->db->get()->result();
    }

    public function get_holiday_list($form_date, $to_date, $created_by)
    {
        $this->db->select('H.*, C.name as created_by');
        $this->db->from('holidays AS H');
        $this->db->join('employees AS C', 'C.user_id = H.created_by', 'left');
        if ($form_date && $to_date) {
            $this->db->where("DATE(H.from_date) AND DATE(H.to_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($created_by) {
            $this->db->where('H.created_by', $created_by);
        }
        $this->db->order_by('H.id', 'DESC');
        return $this->db->get()->result();
    }
}
