<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Expenditure_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_employee_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }
    public function get_expenditure_list($keyword, $form_date, $to_date, $expenditure_head_id, $payment_method, $created_by) {
        $this->db->select('E.*, EH.name as expenditure_head');
        $this->db->from('expenditures AS E');
        $this->db->join('expenditure_heads AS EH', 'EH.id = E.expenditure_head_id', 'left');
        if ($keyword) {
            $this->db->like('E.custom_invoice_id', $keyword);
            $this->db->or_like('E.name', $keyword);
            $this->db->or_like('E.invoice_no', $keyword);
            $this->db->or_like('E.bank_name', $keyword);
            $this->db->or_like('E.cheque_no', $keyword);
            $this->db->or_like('EH.name', $keyword);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(E.date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($expenditure_head_id) {
            $this->db->where('E.expenditure_head_id', $expenditure_head_id);
        }
        if ($payment_method) {
            $this->db->where('E.payment_method', $payment_method);
        }
        if ($created_by) {
            $this->db->where('E.created_by', $created_by);
        }
        $this->db->order_by('E.id', 'ASC');
        return $this->db->get()->result();
    }
}
