<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('monthly'); ?> <?php echo $this->lang->line('attendance'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="d-flex">
            <?php echo $this->load->view('header'); ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('report/attendance/monthly'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="month"><?php echo $this->lang->line('month'); ?></label>
                            <input type="text" class="form-control" name="month" id="month" value="<?php echo isset($month) ?  $month : ''; ?>" placeholder="<?php echo $this->lang->line('month'); ?>" autocomplete="off">
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="department_id"><?php echo $this->lang->line('department'); ?></label>
                            <select class="form-control custom-select select2" name="department_id" id="department_id"onchange="get_designation(this.value)">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('department'); ?></option>
                                <?php foreach ($departments as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($department_id) && $department_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="designation_id"><?php echo $this->lang->line('designation'); ?></label>
                            <select class="form-control custom-select select2" name="designation_id" id="designation_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('designation'); ?></option>
                                <?php foreach ($designations as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($designation_id) && $designation_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="shift_id"><?php echo $this->lang->line('shift'); ?></label>
                            <select class="form-control custom-select select2" name="shift_id" id="shift_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('shift'); ?></option>
                                <?php foreach ($shifts as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($shift_id) && $shift_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="user_id"><?php echo $this->lang->line('employee'); ?></label>
                            <select class="form-control custom-select select2" name="user_id" id="user_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($user_id) && $user_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <?php if (isset($attendances) && !empty($attendances)) { ?>
            <!-- Report Details -->
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <?php if (has_permission(VIEW, 'report', 'attendance')) { ?>
                            <h6 class="card-header d-flex align-items-center">
                                <i class="fa fa-clock-o font-30 mr-10"></i>
                                <?php echo $this->lang->line('monthly'); ?> <?php echo $this->lang->line('attendance'); ?> <?php echo $this->lang->line('report'); ?>
                            </h6>
                        <?php } ?>
                        <?php if (has_permission(ADD, 'report', 'attendance')) { ?>
                            <div class="button-list">
                                <a href="<?php echo site_url('report/attendance/monthly_pdf?month=' . $month . '&department_id=' . $department_id . '&designation_id=' . $designation_id . '&shift_id=' . $shift_id . '&user_id=' . $user_id); ?>" class="btn btn-success btn-xs">
                                    <i class="fa fa-download"></i> <?php echo $this->lang->line('pdf'); ?> <?php echo $this->lang->line('generate'); ?>
                                </a>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="card-body">
                        <style>
                            .table-sm td,
                            .table-sm th {
                                padding: 0 !important;
                            }
                        </style>
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm table-bordered table-hover table-striped mb-0">
                                    <thead class="bg-gradient-streaks text-white">
                                        <tr>
                                            <th class="text-white">
                                                Employee <i class="fa fa-long-arrow-down"></i>
                                                Date <i class="fa fa-long-arrow-right"></i>
                                            </th>
                                            <?php for ($i = 1; $i <= $days; $i++) {
                                                $todayDate = $year_number . '-' . $month_number . '-' . $i;
                                                $unixTimestamp = strtotime($todayDate);
                                                $dayOfWeek = date("D", $unixTimestamp);
                                                $i = str_pad($i, 2, 0, STR_PAD_LEFT);
                                            ?>
                                                <th class="text-white" align="center">
                                                    <strong><?php echo $i; ?></strong><br>
                                                    <hr style="margin: 0; padding: 0;">
                                                    <span style="text-decoration:underline;"><?php echo $dayOfWeek; ?></span>
                                                </th>
                                            <?php } ?>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if (isset($attendances) && !empty($attendances)) { ?>
                                            <?php foreach ($attendances as $obj) { ?>
                                                <tr>
                                                    <td><?php echo $obj->name; ?></td>
                                                    <?php for ($i = 1; $i <= $days; $i++) {
                                                        $i = str_pad($i, 2, 0, STR_PAD_LEFT);
                                                        $attendance_date = $year_number . '-' . $month_number . '-' . $i;
                                                        $get_day = strtotime($attendance_date);
                                                        $day = date('l', $get_day);
                                                        $attendance = $this->attendance->get_monthly_attendance_list($attendance_date, $obj->shift_id, $obj->user_id);
                                                    ?>
                                                        <td align="center">
                                                            <?php
                                                            foreach ($attendance as $row) {
                                                                echo '<p style="text-transform:uppercase">' . $row->attendance_status . '</p>' ?? '';
                                                            ?>
                                                                <small>
                                                                    <p class="p-0">In: <?php echo $row->clock_in ? date('h:ia', strtotime($row->clock_in)) : ''; ?></p>
                                                                    <p class="p-0">Out: <?php echo $row->clock_out ? date('h:ia', strtotime($row->clock_out)) : ''; ?></p>
                                                                </small>
                                                            <?php } ?>
                                                        </td>
                                                    <?php } ?>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#month').daterangepicker({
        minYear: 1901,
        showDropdowns: true,
        singleDatePicker: true,
        locale: {
            format: 'YYYY-MM'
        }
    });
</script>

<script>
    function get_designation(department_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_department_by_designation'); ?>",
            data: {
                department_id: department_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#designation_id').html(response);
                }
            }
        });
    };
</script>