<!DOCTYPE html>
<html>

<head>
    <title>Monthly</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            width: 100%;
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .total {
            margin-top: 20px;
        }

        .total_table tbody td {
            padding: 2px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->
            <h2 align="center">
                MONTHLY ATTENDANCE REPORT
                <br>
                <small>Month: <?php echo date('F, Y', strtotime($month)); ?></small>
            </h2>
            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%" align="left">
                                <?php if (isset($user_id) && !empty($user_id)) { ?>
                                    <b>Employee:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        <?php echo $employee->name; ?>, <?php echo $employee->phone; ?>
                                    </span>
                                <?php } elseif (isset($department_id) && !empty($department_id)) { ?>
                                    <b>Department:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        <?php echo $department->name; ?>
                                    </span>
                                <?php } elseif (isset($shift_id) && !empty($shift_id)) { ?>
                                    <b>Shift:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        <?php echo $shift->name; ?>
                                    </span>
                                <?php } else { ?>
                                    <b>Employee:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        All
                                    </span>
                                <?php } ?>
                            </td>
                            <td width="30%" align="right">
                                <b>Print Date:</b>
                                <span style="font-size: 12px;"><?php echo date('M d, Y h:ia'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <tr>
                            <th>
                                Employee <i class="fa fa-long-arrow-down"></i>
                                Date <i class="fa fa-long-arrow-right"></i>
                            </th>
                            <?php for ($i = 1; $i <= $days; $i++) {
                                $todayDate = $year_number . '-' . $month_number . '-' . $i;
                                $unixTimestamp = strtotime($todayDate);
                                $dayOfWeek = date("D", $unixTimestamp);
                                $i = str_pad($i, 2, 0, STR_PAD_LEFT);
                            ?>
                                <th align="center">
                                    <strong><?php echo $i; ?></strong><br>
                                    <hr style="margin: 0; padding: 0;">
                                    <span style="text-decoration:underline;"><?php echo $dayOfWeek; ?></span>
                                </th>
                            <?php } ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (isset($employees) && !empty($employees)) { ?>
                            <?php foreach ($employees as $obj) { ?>
                                <tr>
                                    <td><?php echo $obj->name; ?></td>
                                    <?php for ($i = 1; $i <= $days; $i++) {
                                        $i = str_pad($i, 2, 0, STR_PAD_LEFT);
                                        $attendance_date = $year_number . '-' . $month_number . '-' . $i;
                                        $get_day = strtotime($attendance_date);
                                        $day = date('l', $get_day);
                                        $attendance = $this->attendance->get_monthly_attendance_list($attendance_date, $obj->shift_id, $obj->user_id);
                                    ?>
                                        <td align="center">
                                            <?php
                                            foreach ($attendance as $row) {
                                                echo '<p style="text-transform:uppercase">' . $row->attendance_status . '</p>' ?? '';
                                            ?>
                                                <small>
                                                    <p class="p-0">In: <?php echo $row->clock_in ? date('h:ia', strtotime($row->clock_in)) : ''; ?></p>
                                                    <p class="p-0">Out: <?php echo $row->clock_out ? date('h:ia', strtotime($row->clock_out)) : ''; ?></p>
                                                </small>
                                            <?php } ?>
                                        </td>
                                    <?php } ?>
                                </tr>
                            <?php } ?>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <!-- Content End -->
            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Prepared By:</b>
                                    <?php echo $this->session->userdata('name'); ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>