<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('summery'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="align-items-center">
            <?php echo $this->load->view('header'); ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('report/mis/summery'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="type"><?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select" name="type" id="type">
                                <option selected value="0"><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('type'); ?></option>
                                <option value="1" <?php echo isset($type) && $type == 1 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('paid'); ?></option>
                                <option value="2" <?php echo isset($type) && $type == 2 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('unpaid'); ?></option>
                                <option value="3" <?php echo isset($type) && $type == 3 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('no_reference'); ?></option>
                                <option value="4" <?php echo isset($type) && $type == 4 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('reference'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" required class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>" autocomplete="off">
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="reference_id"><?php echo $this->lang->line('reference'); ?></label>
                            <select class="form-control custom-select select2" name="reference_id" id="reference_id">
                                <option selected value="0"><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('reference'); ?></option>
                                <?php foreach ($references as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($reference_id) && $reference_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="created_by"><?php echo $this->lang->line('created_by'); ?></label>
                            <select class="form-control custom-select select2" name="created_by" id="created_by">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($created_by) && $created_by == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
        <?php if ($_GET) { ?>
            <!-- Report Details -->
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <?php if (has_permission(VIEW, 'report', 'mis')) { ?>
                            <h6 class="card-header d-flex align-items-center">
                                <i class="fa fa-exchange font-30 mr-10"></i>
                                <?php echo $this->lang->line('summery'); ?> <?php echo $this->lang->line('report'); ?>
                            </h6>
                        <?php } ?>
                        <div class="button-list">
                            <a target="_blank" href="<?php echo site_url('report/mis/summery_pdf/?type=' . $type . '&date=' . $date . '&reference_id=' . $reference_id . '&created_by=' . $created_by); ?>" class="btn btn-success btn-xs">
                                <i class="fa fa-download"></i> <?php echo $this->lang->line('pdf'); ?> <?php echo $this->lang->line('generate'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm table-bordered mb-0">
                                    <thead>
                                        <tr>
                                            <th>SL</th>
                                            <th class="bg-success text-white text-center text-uppercase">Date</th>
                                            <th class="bg-success text-white text-center text-uppercase">IPD</th>
                                            <th class="bg-success text-white text-center text-uppercase">Diagnostic</th>
                                            <th class="bg-success text-white text-center text-uppercase">OPD</th>
                                            <th class="bg-success text-white text-center text-uppercase">Income</th>
                                            <th class="bg-success text-white text-center text-uppercase">Total</th>
                                            <th class="bg-danger text-white text-center text-uppercase">IPD</th>
                                            <th class="bg-danger text-white text-center text-uppercase">Diagnostic</th>
                                            <th class="bg-danger text-white text-center text-uppercase">Surgeon</th>
                                            <th class="bg-danger text-white text-center text-uppercase">Anesth.</th>
                                            <th class="bg-danger text-white text-center text-uppercase">Assist.</th>
                                            <th class="bg-danger text-white text-center text-uppercase">Expense</th>
                                            <th class="bg-danger text-white text-center text-uppercase">Total</th>
                                            <th class="bg-success text-white text-center text-uppercase">Total</th>
                                        </tr>

                                    </thead>
                                    <tbody>
                                        <?php
                                        $count = 1;
                          				$total_ipd_income=0;
                          				$total_diagnostic_income=0;
                                        $total_opd_income=0;
                          				$total_income=0;
                          				$in_total_income=0;
                          				$total_ipd_expense=0;
                          				$total_diagnostic_expense=0;
                          				$total_surgeon_expense=0;
                          				$total_anesthetist_expense=0;
                          				$total_assistant_expense=0;
                          				$total_expense=0;
                          				$in_total_expense=0;
                          				$all_total=0;
                                        foreach ($date_range as $obj) { 
                                      	$total_ipd_income += $obj['ipd_income'];
                                        $total_diagnostic_income += $obj['diagnostic_income'];
                                        $total_opd_income += $obj['opd_income'];
                          				$total_income += $obj['income'];
                          				$in_total_income += $obj['total_income'];
                          				$total_ipd_expense += $obj['ipd_expense'];
                          				$total_diagnostic_expense += $obj['diagnostic_expense'];
                          				$total_surgeon_expense += $obj['surgeon_expense'];
                          				$total_anesthetist_expense += $obj['anesthetist_expense'];
                          				$total_assistant_expense += $obj['assistant_expense'];
                          				$total_expense += $obj['expense'];
                          				$in_total_expense += $obj['total_expense'];
                          				$all_total += $obj['total'];
                                      ?>                                      		
                                            <tr>
                                                <td><?php echo $count++; ?></td>
                                                <td><?php echo $obj['date']; ?></td>
                                                <td><?php echo number_format($obj['ipd_income'],0 ); ?></td>
                                                <td><?php echo number_format($obj['diagnostic_income'],0 ); ?></td>
                                                <td><?php echo number_format($obj['opd_income'],0 ); ?></td>
                                                <td><?php echo number_format($obj['income'],0 ); ?></td>
                                                <td><?php echo number_format($obj['total_income'],0 ); ?></td>
                                                <td><?php echo number_format($obj['ipd_expense'],0 ); ?></td>
                                                <td><?php echo number_format($obj['diagnostic_expense'],0 ); ?></td>
                                                <td><?php echo number_format($obj['surgeon_expense'],0 ); ?></td>
                                                <td><?php echo number_format($obj['anesthetist_expense'],0 ); ?></td>
                                                <td><?php echo number_format($obj['assistant_expense'],0 ); ?></td>
                                                <td><?php echo number_format($obj['expense'],0 ); ?></td>
                                                <td><?php echo number_format($obj['total_expense'],0 ); ?></td>
                                                <td><?php echo number_format($obj['total'],0 ); ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                  <tfoot>
                                    <tr>
                                      <td colspan="2">Total</td>
                                      <td><?php echo $total_ipd_income; ?></td>
                                      <td><?php echo $total_diagnostic_income; ?></td>
                                      <td><?php echo $total_opd_income; ?></td>
                                      <td><?php echo $total_income; ?></td>
                                      <td><?php echo $in_total_income; ?></td>
                                      <td><?php echo $total_ipd_expense; ?></td>
                                      <td><?php echo $total_diagnostic_expense; ?></td>
                                      <td><?php echo $total_surgeon_expense; ?></td>
                                      <td><?php echo $total_anesthetist_expense; ?></td>
                                      <td><?php echo $total_assistant_expense; ?></td>
                                      <td><?php echo $total_expense; ?></td>
                                      <td><?php echo $in_total_expense; ?></td>
                                      <td><?php echo $all_total; ?></td>
                                    </tr>
                                  </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(document).ready(function() {
        $(".select2").select2();

        $('#range').daterangepicker({
            autoUpdateInput: false,
            startDate: new Date(),
            endDate: moment(),
            showDropdowns: true,
            minYear: 1901,
            locale: {
                format: 'YYYY/MM/DD',
            },
            maxDate: moment().endOf('day'), // Limit to today's date
            maxSpan: {
                "days": 31 // Limit the maximum span to 31 days
            },
            ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Tomorrow': [moment().add(1, 'days'), moment().add(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                'This Year': [moment().startOf('year'), moment().endOf('year')],
                'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
            }
        });

        $('input[id="range"]').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('YYYY/MM/DD') + ' - ' + picker.endDate.format('YYYY/MM/DD'));
        });

        $('input[id="range"]').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
        });
    });
</script>