<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Smssetting.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Smssetting
 * @description     : Manage application sms settings.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Smssetting extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Setting_Model', 'setting', true);
    }

    /*     * ***************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "SMS Setting" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function index() {

        check_permission(VIEW);

        $this->data['sms_settings'] = $this->setting->get_single('sms_settings', array('status' => 1));

        $this->layout->title($this->lang->line('sms') . ' ' . $this->lang->line('setting') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('sms_setting/index', $this->data);
    }

    /*     * ***************Function add**********************************
     * @type            : Function
     * @function name   : add
     * @description     : Load "New SMS Settings" user interface
     *                    and process to store "SMS Settings" into database
     *                    for the first time settings
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function add() {

        check_permission(ADD);

        if ($_POST) {
            $this->_prepare_setting_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_setting_data();

                $insert_id = $this->setting->insert('sms_settings', $data);
                if ($insert_id) {
                    create_log('Has been created sms setting');
                    success($this->lang->line('insert_success'));
                    redirect('setting/smssetting');
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('setting/smssetting/add');
                }
            } else {
                $this->data = $_POST;
            }
        }

        $this->layout->title($this->lang->line('sms') . ' ' . $this->lang->line('setting') . ' | ' . $this->data['setting']->brand_title);
        $this->layout->view('sms_setting/index', $this->data);
    }

    /*     * ***************Function edit**********************************
     * @type            : Function
     * @function name   : edit
     * @description     : Load Update "SMS Settings" user interface
     *                    with populate "SMS Settings" value
     *                    and process to update "SMS Settings" into database
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */

    public function edit($id = null) {

        check_permission(EDIT);

        if ($_POST) {
            $this->_prepare_setting_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_setting_data();
                $updated = $this->setting->update('sms_settings', $data, array('id' => $this->input->post('id')));

                if ($updated) {
                    create_log('Has been updated global setting');
                    success($this->lang->line('update_success'));
                    redirect('setting/smssetting');
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('setting/smssetting/edit/' . $this->input->post('id'));
                }
            }
        }

        $this->layout->title($this->lang->line('sms') . ' ' . $this->lang->line('setting') . ' | ' . $this->data['setting']->brand_title ? $this->data['setting']->brand_title : TITLE);
        $this->layout->view('sms_setting/index', $this->data);
    }

    /*     * ***************Function _prepare_setting_validation**********************************
     * @type            : Function
     * @function name   : _prepare_setting_validation
     * @description     : Process "SMS Settings" user input data validation
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    private function _prepare_setting_validation() {

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');

        $this->form_validation->set_rules('mimsms_api_key', $this->lang->line('brand') . ' ' . $this->lang->line('title'), 'trim');
        $this->form_validation->set_rules('mimsms_type', $this->lang->line('brand') . ' ' . $this->lang->line('name'), 'trim');
        $this->form_validation->set_rules('mimsms_sender_id', $this->lang->line('time_zone'), 'trim|required');
        $this->form_validation->set_rules('mimsms_status', $this->lang->line('date_format'), 'trim|required');
        $this->form_validation->set_rules('price', $this->lang->line('price'), 'trim|required');
    }

    /*     * ***************Function _get_posted_setting_data**********************************
     * @type            : Function
     * @function name   : _get_posted_setting_data
     * @description     : Prepare "SMS Settings" user input data to save into database
     *
     * @param           : null
     * @return          : $data array(); value
     * ********************************************************** */

    private function _get_posted_setting_data() {

        $items = array();
        $items[] = 'mimsms_api_key';
        $items[] = 'mimsms_type';
        $items[] = 'mimsms_sender_id';
        $items[] = 'mimsms_status';
        $items[] = 'price';

        $data = elements($items, $_POST);
        
        if ($this->input->post('id')) {
            $data['modified_at'] = date('Y-m-d H:i:s');
            $data['modified_by'] = logged_in_user_id();
        } else {

            $data['status'] = 1;
            $data['created_at'] = date('Y-m-d H:i:s');
            $data['created_by'] = logged_in_user_id();
        }

        return $data;
    }
}
