<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Smstemplate.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Smstemplate
 * @description     : Manage sms template.
 * @author          : South Bangla IT Zone Team
 * @url             : https://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Smstemplate extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Setting_Model', 'setting', true);
    }


    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "SMS Template List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        $search = $this->input->get('search');
        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);
        if ($search) {
            $config['base_url'] = site_url('setting/smstemplate/?search=') . $search;
        } else {
            $config['base_url'] = current_url();
        }
        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        $config['total_rows'] = $this->setting->get_sms_template_list($config['per_page'], $offset, $search, $count = TRUE);
        $this->pagination->initialize($config);
        $this->data['templates'] = $this->setting->get_sms_template_list($config['per_page'], $offset, $search, $count = FALSE);

        $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        $this->data['search'] = $search;

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('manage') . ' ' . $this->lang->line('sms') . ' ' . $this->lang->line('template') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('sms_template/index', $this->data);
    }


    /*****************Function add**********************************
     * @type            : Function
     * @function name   : add
     * @description     : Load "Add new SMS template" user interface
     *                    and store "SMS template" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function add() {

        check_permission(ADD);

        if ($_POST) {
            $this->_prepare_template_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_template_data();

                $insert_id = $this->setting->insert('sms_templates', $data);
                if ($insert_id) {
                    create_log('Has been created a sms Template : ' . $data['title']);
                    success($this->lang->line('insert_success'));
                    redirect('setting/smstemplate');
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('setting/smstemplate/add');
                }
            } else {
                $this->data = $_POST;
            }
        }

        $this->data['roles'] = $this->setting->get_list('roles', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['types'] = $this->setting->get_list('notifications', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('add') . ' ' . $this->lang->line('template') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('sms_template/add', $this->data);
    }


    /*****************Function edit**********************************
     * @type            : Function
     * @function name   : edit
     * @description     : Load Update "SMS template" user interface
     *                    with populated "SMS template" value
     *                    and update "SMS template" database
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function edit($id = null) {

        check_permission(EDIT);

        if ($_POST) {
            $this->_prepare_template_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_template_data();
                $updated = $this->setting->update('sms_templates', $data, array('id' => $this->input->post('id')));

                if ($updated) {

                    create_log('Has been updated a sms Template : ' . $data['title']);

                    success($this->lang->line('update_success'));
                    redirect('setting/smstemplate');
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('setting/smstemplate/edit/' . $this->input->post('id'));
                }
            } else {
                $this->data['template'] = $this->setting->get_single('sms_templates', array('id' => $this->input->post('id')));
            }
        } else {
            if ($id) {
                $this->data['template'] = $this->setting->get_single('sms_templates', array('id' => $id));

                if (!$this->data['template']) {
                    redirect('setting/smstemplate');
                }
            }
        }

        $this->data['roles'] = $this->setting->get_list('roles', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['types'] = $this->setting->get_list('notifications', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['edit'] = TRUE;
        $this->layout->title($this->lang->line('edit') . ' ' . $this->lang->line('template') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('sms_template/edit', $this->data);
    }


    /*****************Function _prepare_template_validation**********************************
     * @type            : Function
     * @function name   : _prepare_template_validation
     * @description     : Process "Email template" user input data validation
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    private function _prepare_template_validation() {
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
        $this->form_validation->set_rules('type', $this->lang->line('template') . ' ' . $this->lang->line('type'), 'trim|required|callback_type');
        $this->form_validation->set_rules('title', $this->lang->line('template') . ' ' . $this->lang->line('title'), 'trim|required');
        $this->form_validation->set_rules('role_id', $this->lang->line('role'), 'trim|required');
        $this->form_validation->set_rules('template', $this->lang->line('template'), 'trim|required');
    }


    /*****************Function type**********************************
     * @type            : Function
     * @function name   : title
     * @description     : Unique check for "SMS template type" data/value
     *
     * @param           : null
     * @return          : boolean true/false
     * ********************************************************** */
    public function type() {
        if ($this->input->post('id') == '') {
            $template = $this->setting->duplicate_check_sms_template($this->input->post('type'), $this->input->post('role_id'));
            if ($template) {
                $this->form_validation->set_message('type', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else if ($this->input->post('id') != '') {
            $template = $this->setting->duplicate_check_sms_template($this->input->post('type'), $this->input->post('role_id'), $this->input->post('id'));
            if ($template) {
                $this->form_validation->set_message('type', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            return TRUE;
        }
    }

    /*****************Function _get_posted_template_data**********************************
     * @type            : Function
     * @function name   : _get_posted_template_data
     * @description     : Prepare "SMS template" user input data to save into database
     *
     * @param           : null
     * @return          : $data array(); value
     * ********************************************************** */
    private function _get_posted_template_data() {

        $items = array();
        $items[] = 'type';
        $items[] = 'title';
        $items[] = 'role_id';
        $items[] = 'template';
        $data = elements($items, $_POST);

        if ($this->input->post('id')) {
            $data['modified_at'] = date('Y-m-d H:i:s');
            $data['modified_by'] = logged_in_user_id();
        } else {
            $data['status'] = 1;
            $data['created_at'] = date('Y-m-d H:i:s');
            $data['created_by'] = logged_in_user_id();
        }

        return $data;
    }


    /*****************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "SMS template" from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('setting/smstemplate');
        }

        $template = $this->setting->get_single('sms_templates', array('id' => $id));

        if ($this->setting->delete('sms_templates', array('id' => $id))) {

            create_log('Has been deleted a sms Template : ' . $template->title);

            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect('setting/smstemplate');
    }
}
