<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('role'); ?> <?php echo $this->lang->line('permission'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('role'); ?> <?php echo $this->lang->line('permission'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('setting/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <?php if (isset($list) && !empty($list)) { ?>
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <?php if (has_permission(VIEW, 'setting', 'role')) { ?>
                            <h6 class="card-header d-flex align-items-center">
                                <i class="fa fa-braille font-30 mr-10"></i>
                                <?php echo $this->lang->line('role_permission'); ?>
                            </h6>
                        <?php } ?>
                        <?php echo form_open_multipart(site_url('setting/permission'), array('name' => 'search', 'id' => 'search', 'class' => 'needs-validation', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                        <div class="form-group">
                            <div class="input-group input-group-sm">
                                <input type="text" class="form-control" name="search" id="search" value="<?php echo isset($search) ?  $search : ''; ?>" placeholder="<?php echo $this->lang->line('search'); ?>" required>
                                <div class="input-group-append">
                                    <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('search'); ?></button>
                                </div>
                            </div>
                        </div>
                        <?php echo form_close(); ?>
                        <?php if (has_permission(ADD, 'setting', 'role')) { ?>
                            <div class="align-items-center">
                                <a href="<?php echo site_url('setting/role/add'); ?>" class="btn btn-xs btn-primary">
                                    <i class="fa fa-plus"></i>
                                    <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('role'); ?>
                                </a>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm mb-0">
                                    <thead>
                                        <tr>
                                            <th><?php echo $this->lang->line('sl_no'); ?></th>
                                            <th><?php echo $this->lang->line('role'); ?> <?php echo $this->lang->line('name'); ?></th>
                                            <th><?php echo $this->lang->line('note'); ?></th>
                                            <th><?php echo $this->lang->line('is_default'); ?></th>
                                            <th><?php echo $this->lang->line('action'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1;
                                        if (isset($roles) && !empty($roles)) { ?>
                                            <?php foreach ($roles as $obj) { ?>
                                                <tr>
                                                    <td><?php echo $count++; ?></td>
                                                    <td><?php echo ucfirst($obj->name); ?></td>
                                                    <td><?php echo $obj->note; ?></td>
                                                    <td><?php echo $obj->is_default ? $this->lang->line('yes') : $this->lang->line('no'); ?></td>
                                                    <td>
                                                        <?php if (has_permission(EDIT, 'setting', 'permission')) { ?>
                                                            <a href="<?php echo site_url('setting/permission/index/' . $obj->id); ?>" class="btn btn-success btn-xs"><i class="fa fa-folder-open-o"></i> <?php echo $this->lang->line('role_permission'); ?> <?php echo $this->lang->line('setting'); ?> </a>
                                                        <?php } ?>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- Card Footer -->
                    <?php if ($this->pagination->create_links()) { ?>
                        <div class="card-footer justify-content-end">
                            <?php echo $this->pagination->create_links(); ?>
                        </div>
                    <?php } ?>
                </div>
            <?php } ?>

            <!-- Permission Start -->
            <?php if (isset($permission)) { ?>
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-braille font-30 mr-10"></i>
                            <?php echo $this->lang->line('role_permission'); ?> : <span class="text-primary"><?php echo $role->name; ?></span>
                        </h6>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('setting/permission'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list"></i>
                                <?php echo $this->lang->line('role_permission'); ?>
                            </a>
                        </div>
                    </div>
                    <?php echo form_open_multipart(site_url('setting/permission/index/' . $role_id), array('name' => 'permission', 'id' => 'permission', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm mb-0">
                                    <thead>
                                        <tr>
                                            <th><?php echo $this->lang->line('sl_no'); ?></th>
                                            <th><?php echo $this->lang->line('module'); ?> <?php echo $this->lang->line('name'); ?></th>
                                            <th><?php echo $this->lang->line('function'); ?> <?php echo $this->lang->line('name'); ?></th>
                                            <th><?php echo $this->lang->line('view'); ?> &nbsp; <input type="checkbox" id="fn_view" class="role-check" value="1" /> </th>
                                            <th><?php echo $this->lang->line('add'); ?> &nbsp;<input type="checkbox" id="fn_add" class="role-check" value="1" /></th>
                                            <th><?php echo $this->lang->line('edit'); ?> &nbsp;<input type="checkbox" id="fn_edit" class="role-check" value="1" /></th>
                                            <th><?php echo $this->lang->line('delete'); ?> &nbsp; <input type="checkbox" id="fn_delete" class="role-check" value="1" /></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if (isset($modules) && !empty($modules)) { ?>
                                            <?php $module = 1;
                                            foreach ($modules as $obj) { ?>
                                                <tr>
                                                    <td><?php echo $module; ?></td>
                                                    <td colspan="6" class="role-text" style="background: #ececec; font-weight: bold;"><?php echo $obj->module_name; ?> &raquo;</td>
                                                </tr>
                                                <?php $operations = get_operation_by_module($obj->id); ?>
                                                <?php if (isset($operations) && !empty($operations)) { ?>
                                                    <?php $operaton = 1;
                                                    foreach ($operations as $op) { ?>
                                                        <?php $permission = get_permission_by_operation($role_id, $op->id); ?>
                                                        <tr>
                                                            <td><?php echo $module; ?>.<?php echo $operaton++; ?></td>
                                                            <td colspan="2">
                                                                <?php echo $op->operation_name; ?>
                                                                <input type="hidden" name="operation[<?php echo $op->id; ?>]" id="operatio[]" value="<?php echo $op->id; ?>" />
                                                            </td>
                                                            <?php if ($op->is_view_vissible) { ?>
                                                                <td>
                                                                    <input type="checkbox" class="fn_view" name="is_view[<?php echo $op->id; ?>]" value="1" <?php echo isset($permission->is_view) && $permission->is_view == 1 ? 'checked="checked"' : ""; ?> />
                                                                </td>
                                                            <?php } ?>
                                                            <?php if ($op->is_add_vissible) { ?>
                                                                <td>
                                                                    <input type="checkbox" class="fn_add" name="is_add[<?php echo $op->id; ?>]" value="1" <?php echo isset($permission->is_add) && $permission->is_add == 1 ? 'checked="checked"' : ""; ?> />
                                                                </td>
                                                            <?php } ?>
                                                            <?php if ($op->is_edit_vissible) { ?>
                                                                <td>
                                                                    <input type="checkbox" class="fn_edit" name="is_edit[<?php echo $op->id; ?>]" value="1" <?php echo isset($permission->is_edit) && $permission->is_edit == 1 ? 'checked="checked"' : ""; ?> />
                                                                </td>
                                                            <?php } ?>
                                                            <?php if ($op->is_delete_vissible) { ?>
                                                                <td>
                                                                    <input type="checkbox" class="fn_delete" name="is_delete[<?php echo $op->id; ?>]" value="1" <?php echo isset($permission->is_delete) && $permission->is_delete == 1 ? 'checked="checked"' : ""; ?> />
                                                                </td>
                                                            <?php } ?>
                                                        </tr>
                                                    <?php } ?>
                                                <?php } ?>
                                            <?php $module++;
                                            } ?>
                                        <?php } else { ?>
                                            <tr>
                                                <td colspan="7" class="not-found"><?php echo $this->lang->line('no_data_found'); ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- Card Footer -->
                    <div class="card-footer pt-0">
                        <div class="button-list">
                            <input type="hidden" name="role_id" id="role_id" value="<?php echo $role_id;; ?>" />
                            <a class="btn btn-gradient-danger" href="<?php echo site_url('setting/permission'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                            <?php if (has_permission(EDIT, 'setting', 'permission')) { ?>
                                <?php if ($role_id == 100) { ?>
                                    <button type="button" disabled="disabled" class="btn btn-gradient-primary"><?php echo $this->lang->line('update'); ?> <?php echo $this->lang->line('role_permission'); ?></button>
                                <?php } else { ?>
                                    <button type="submit" class="btn btn-gradient-primary"><?php echo $this->lang->line('update'); ?> <?php echo $this->lang->line('role_permission'); ?></button>
                                <?php } ?>
                            <?php } ?>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            <?php } ?>
            <!-- Permission End -->
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<script type="text/javascript">
    /* Permission */
    $('#fn_view').click(function() {
        if ($(this).is(':checked')) {
            $(".fn_view").prop("checked", true);
        } else {
            $(".fn_view").prop("checked", false);
        }
    });
    $('#fn_add').click(function() {
        if ($(this).is(':checked')) {
            $(".fn_add").prop("checked", true);
        } else {
            $(".fn_add").prop("checked", false);
        }
    });
    $('#fn_edit').click(function() {
        if ($(this).is(':checked')) {
            $(".fn_edit").prop("checked", true);
        } else {
            $(".fn_edit").prop("checked", false);
        }
    });
    $('#fn_delete').click(function() {
        if ($(this).is(':checked')) {
            $(".fn_delete").prop("checked", true);
        } else {
            $(".fn_delete").prop("checked", false);
        }
    });
</script>