<!-- Home Design Inner Pages -->
<div class="ulockd-inner-home">
    <div class="container">
        <div class="row">
            <div class="inner-conraimer-details">
                <div class="col-md-12">
                    <h1 class="text-uppercase"><?php echo $this->lang->line('our'); ?> <?php echo $this->lang->line('doctor'); ?></h1>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Home Design Inner Pages -->
<div class="ulockd-inner-page">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="ulockd-icd-layer">
                    <ul class="list-inline ulockd-icd-sub-menu">
                        <li><a href="<?php echo site_url(); ?>"> <?php echo $this->lang->line('home'); ?> </a></li>
                        <li>></li>
                        <li><?php echo $this->lang->line('doctor'); ?></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Inner Pages Main Section -->

<!-- Our Doctor -->
<section class="ulockd-fservice">
    <div class="container">
        <div class="row">
            <div class="col-md-6 col-md-offset-3 text-center">
                <div class="ulockd-main-title">
                    <h2 class="mt-separator"><?php echo $this->lang->line('our'); ?> <?php echo $this->lang->line('doctor'); ?></h2>
                    <?php if ($this->session->userdata('site_lang') == 'bengali') { ?>
                        <p><?php echo isset($this->sections->bn_doctor) && !empty($this->sections->bn_doctor) ? $this->sections->bn_doctor : ''; ?></p>
                    <?php } else { ?>
                        <p><?php echo isset($this->sections->doctor) && !empty($this->sections->doctor) ? $this->sections->doctor : ''; ?></p>
                    <?php } ?>
                </div>
            </div>
        </div>
        <form action="<?php echo site_url('doctors'); ?>" method="post">
            <div class="row">
                <div class="col-md-5 col-xs-12">
                    <div class="input-group">
                        <span class="input-group-addon"><i class="fa fa-hospital-o"></i></span>
                        <select class="form-control" id="department_id" name="department_id">
                            <option value="" selected><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('department'); ?></option>
                            <?php foreach ($departments as $obj) { ?>
                                <option value="<?php echo $obj->id; ?>" <?php echo isset($department_id) && $department_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                            <?php } ?>
                        </select>
                        <div class="help-block with-errors"><?php echo form_error('department_id'); ?></div>
                    </div>
                </div>
                <div class="col-md-5 col-xs-12 margin-bottom-20">
                    <div class="input-group">
                        <span class="input-group-addon"><i class="fa fa-user-md"></i></span>
                        <input type="text" class="form-control" id="keyword" name="keyword" value="<?php echo isset($keyword) ?  $keyword : ''; ?>" placeholder="<?php echo $this->lang->line('doctor'); ?> <?php echo $this->lang->line('name'); ?>">
                        <div class="help-block with-errors"><?php echo form_error('keyword'); ?></div>
                    </div>
                </div>
                <div class="col-md-2 col-xs-12">
                    <button type="submit" class="btn btn-primary"><?php echo $this->lang->line('search'); ?></button>
                </div>
            </div>
        </form>

        <?php if (isset($doctors) && !empty($doctors)) { ?>
            <div class="row">
                <h2 class="ulockd-mrgn1225 ulockd-mrgn625"><?php echo $this->lang->line('search'); ?> <?php echo $this->lang->line('result'); ?>:</h2>
                <?php foreach ($doctors as $obj) { ?>
                    <div class="col-md-4 col-sm-4 col-xs-12">
                        <div class="doctor">
                            <div class="doctor-image">
                                <?php if ($obj->photo) { ?>
                                    <img src="<?php echo UPLOAD_PATH; ?>employee-photo/<?php echo $obj->photo; ?>" alt="<?php echo $this->session->userdata('site_lang') == 'bengali' ? $obj->bn_name : $obj->name; ?>" />
                                <?php } elseif ($obj->gender == 'male') { ?>
                                    <img src="<?php echo IMG_URL; ?>doctor-male.png" alt="male" />
                                <?php } else { ?>
                                    <img src="<?php echo IMG_URL; ?>doctor-female.png" alt="female" />
                                <?php } ?>
                            </div>
                            <div class="doctor-details">
                                <h4><?php echo $this->session->userdata('site_lang') == 'bengali' ? $obj->bn_name : $obj->name; ?></h4>
                                <h5><?php echo $obj->specialist; ?></h5>
                                <p><?php echo $this->session->userdata('site_lang') == 'bengali' ? $obj->bn_designation : $obj->designation; ?></p>
                            </div>
                            <div class="doctorButton">
                                <div class="row">
                                    <a href="<?php echo site_url('appointment?department_id=' . $obj->department_id . '&doctor_id=' . $obj->user_id); ?>" class="col-md-6">
                                        <i class="fa fa-medkit" aria-hidden="true"></i>
                                        <?php echo $this->lang->line('make'); ?> <?php echo $this->lang->line('appointment'); ?>
                                    </a>
                                    <a class="col-md-1"> || </a>
                                    <a href="<?php echo site_url('doctor/' . $obj->id); ?>" class="col-md-5">
                                        <i class="fa fa-external-link" aria-hidden="true"></i>
                                        <?php echo $this->lang->line('read_more'); ?>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        <?php } ?>
    </div>
</section>