<!-- Home Design Inner Pages -->
<div class="ulockd-inner-home">
    <div class="container">
        <div class="row">
            <div class="inner-conraimer-details">
                <div class="col-md-12">
                    <h1 class="text-uppercase"><?php echo $this->session->userdata('site_lang') == 'bengali' ? $doctor->bn_name : $doctor->name; ?></h1>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Home Design Inner Pages -->
<div class="ulockd-inner-page">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="ulockd-icd-layer">
                    <ul class="list-inline ulockd-icd-sub-menu">
                        <li><a href="<?php echo site_url(); ?>"> <?php echo $this->lang->line('home'); ?> </a></li>
                        <li>></li>
                        <li><a href="<?php echo site_url('departments'); ?>"><?php echo $this->lang->line('department'); ?></a> </li>
                        <li>></li>
                        <li><?php echo $this->session->userdata('site_lang') == 'bengali' ? $doctor->bn_name : $doctor->name; ?></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Inner Pages Main Section -->

<!-- Our Doctor Profile -->
<section class="ulockd-team-one">
    <div class="container">
        <div class="row">
            <div class="col-md-6 col-md-offset-3 text-center">
                <div class="ulockd-main-title">
                    <h2 class="mt-separator"><?php echo $this->lang->line('doctor'); ?> <?php echo $this->lang->line('info'); ?></h2>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xxs-12 col-xs-6 col-sm-6 col-md-4">
                <div class="team-one style2">
                    <div class="team-thumb">
                        <?php if ($doctor->photo) { ?>
                            <img class="img-responsive img-whp" src="<?php echo UPLOAD_PATH; ?>employee-photo/<?php echo $doctor->photo; ?>" alt="<?php echo $this->session->userdata('site_lang') == 'bengali' ? $doctor->bn_name : $doctor->name; ?>" />
                        <?php } elseif ($doctor->gender == 'male') { ?>
                            <img class="img-responsive img-whp" src="<?php echo IMG_URL; ?>doctor-male.png" alt="male" />
                        <?php } else { ?>
                            <img class="img-responsive img-whp" src="<?php echo IMG_URL; ?>doctor-female.png" alt="female" />
                        <?php } ?>
                    </div>
                    <div class="team-details text-left">
                        <h3 class="member-name"><?php echo $this->session->userdata('site_lang') == 'bengali' ? $doctor->bn_name : $doctor->name; ?></h3>
                        <h5 class="member-post"><?php echo $this->session->userdata('site_lang') == 'bengali' ? $doctor->bn_designation : $doctor->designation; ?></h5>
                        <ul class="list-inline team-icon">
                            <?php if (isset($social) && !empty($social->facebook_url)) { ?>
                                <li><a href="<?php echo get_http($social->facebook_url); ?>" target="_blank"><i class="fa fa-facebook"></i></a></li>
                            <?php } ?>

                            <?php if (isset($social) && !empty($social->twitter_url)) { ?>
                                <li><a href="<?php echo get_http($social->twitter_url); ?>" target="_blank"><i class="fa fa-twitter"></i></a></li>
                            <?php } ?>

                            <?php if (isset($social) && !empty($social->linkedin_url)) { ?>
                                <li><a href="<?php echo get_http($social->linkedin_url); ?>" target="_blank"><i class="fa fa-linkedin"></i></a></li>
                            <?php } ?>

                            <?php if (isset($social) && !empty($social->instagram_url)) { ?>
                                <li><a href="<?php echo get_http($social->instagram_url); ?>" target="_blank"><i class="fa fa-instagram"></i></a></li>
                            <?php } ?>

                            <?php if (isset($social) && !empty($social->skype)) { ?>
                                <li><a href="skype:<?php echo $social->skype; ?>?chat"><i class="fa fa-skype"></i></a></li>
                            <?php } ?>

                            <?php if (isset($doctor) && !empty($doctor->email)) { ?>
                                <li><a href="mailto:<?php echo $social->email; ?>"><i class="fa fa-envelope"></i> <?php echo $social->email; ?></a></li>
                            <?php } ?>
                        </ul>
                        <a class="btn btn-default btn-lg ulockd-btn-thm2 text-cente" href="<?php echo site_url('appointment?department_id=' . $doctor->department_id . '&doctor_id=' . $doctor->user_id); ?>">
                            <?php echo $this->lang->line('make'); ?> <?php echo $this->lang->line('appointment'); ?>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-xxs-12 col-xs-6 col-sm-6 col-md-8">
                <div class="thumbnail">
                    <div class="caption">
                        <ul class="list-unstyled ulockd-pesonar-info">
                        <li><strong><?php echo $this->lang->line(''); ?><?php echo $this->session->userdata('site_lang') == 'bengali' ? $doctor->bn_name : $doctor->name; ?></strong></li>
                            <li><strong><?php echo $this->lang->line(''); ?> </strong> <?php echo $this->session->userdata('site_lang') == 'bengali' ? $doctor->bn_department : $doctor->department; ?></li>
                          	<li><strong><?php echo $this->lang->line(''); ?> </strong> <?php echo $doctor->specialist; ?></li>                        
                            <li><strong><?php echo $this->lang->line('phone'); ?> :</strong> <?php echo $this->session->userdata('site_lang') == 'bengali' ? en2bn($doctor->phone) : $doctor->phone; ?></li>
                            <li><strong><?php echo $this->lang->line('email'); ?> :</strong> <?php echo $doctor->email; ?></li>
                            <li><strong><?php echo $this->lang->line('address'); ?> :</strong> <?php echo $doctor->present_address; ?></li>                           
                        </ul>
                        <p class="text-justify"><?php echo $doctor->about; ?></p>
                    </div>
                </div>
                <div class="ulockd-apmnmnt-schedule">
                    <table class="table ulockd-two">
                        <caption>
                            <h3>Doctor's Schedule</h3>
                        </caption>
                        <thead>
                            <tr>
                                <th>Day</th>
                                <th class="text-center">Hour</th>
                            </tr>
                        </thead>
                        <?php if (isset($doctor_schedules) && !empty($doctor_schedules)) { ?>
                            <tbody>
                                <?php foreach ($doctor_schedules as $obj) { ?>
                                    <tr>
                                        <th scope="row"><?php echo  $this->lang->line($obj->day); ?></th>
                                        <td><?php echo date($this->global_setting->time_format, strtotime($obj->start_time)); ?> - <?php echo date($this->global_setting->time_format, strtotime($obj->end_time)); ?></td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        <?php } ?>
                    </table>
                </div>
            </div>            
        </div>
    </div>
</section>