<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('test_option'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-list"></i></span>
            <?php echo $this->lang->line('manage'); ?> <?php echo $this->lang->line('test_option'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
    <?php $this->load->view('diagnostic/template/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'diagnostic', 'template')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-list font-30 mr-10"></i>
                            <?php echo $this->lang->line('test_option'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(ADD, 'diagnostic', 'template')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('diagnostic/template/option_add'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-plus font-12 mr-5"></i>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('test_option'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover mb-0">
                            <thead>
                                <tr>
                                    <th><?php echo $this->lang->line('sl_no'); ?></th>
                                    <th><?php echo $this->lang->line('test'); ?></th>
                                    <th><?php echo $this->lang->line('template'); ?></th>
                                    <th><?php echo $this->lang->line('option_name'); ?></th>
                                    <th><?php echo $this->lang->line('status'); ?></th>
                                    <th><?php echo $this->lang->line('action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $count = 1;
                                if (isset($options) && !empty($options)) {
                                    foreach ($options as $obj) {
                                ?>
                                        <tr>
                                            <td><?php echo $count++; ?></td>
                                            <td><?php echo $obj->test_name; ?></td>
                                            <td><?php echo $obj->template_name; ?></td>
                                            <td><?php echo $obj->option_name; ?></td>
                                            <td>
                                                <?php if ($obj->status == 1) { ?>
                                                    <span class="badge badge-success"><?php echo $this->lang->line('active'); ?></span>
                                                <?php } else { ?>
                                                    <span class="badge badge-danger"><?php echo $this->lang->line('inactive'); ?></span>
                                                <?php } ?>
                                            </td>
                                            <td>
                                                <?php if (has_permission(EDIT, 'diagnostic', 'template')) { ?>
                                                    <a href="<?php echo site_url('diagnostic/template/option_edit/' . $obj->id); ?>" class="btn btn-xs btn-info">
                                                        <i class="fa fa-pencil"></i>
                                                    </a>
                                                <?php } ?>
                                                <?php if (has_permission(DELETE, 'diagnostic', 'template')) { ?>
                                                    <a href="<?php echo site_url('diagnostic/template/option_delete/' . $obj->id); ?>" class="btn btn-xs btn-danger" onclick="javascript: return confirm('<?php echo $this->lang->line('are_you_sure'); ?>');">
                                                        <i class="fa fa-trash"></i>
                                                    </a>
                                                <?php } ?>
                                            </td>
                                        </tr>
                                <?php }
                                } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->