<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * ***************Dashboard.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Dashboard
 * @description     : This class used to showing basic statistics of whole application 
 *                    for logged in user.  
 * @author          : South Bangla IT Zone Team 	
 * @url             : http://hms.rabiulbd.com    
 * @support         : rabibd.it@gmail.com	
 * @copyright       : South Bangla IT Zone Team		
 * ********************************************************** */

class Dashboard extends MY_Controller {
    public $data = array();

    public function __construct() {
        parent::__construct();
        $this->load->model('Dashboard_Model', 'dashboard', true);
    }

    public function up() {

        $invoice = $this->dashboard->totalbill();
        foreach ($invoice as $inv) {
            echo $inv->payment_delivery . '=>' . $inv->delivery_remark . '=>' . $inv->delivery_date . '<br>';
            echo $inv->i_payment_delivery . '=>' . $inv->i_delivery_remark . '=>' . $inv->i_delivery_date . '<br>';
            // echo $inv->payment_delivery . '=>' . $inv->invoiceID . '=>' . $inv->commission_payment . '=>' . $inv->paid_status . '<br>';

            $data = array(
                'payment_delivery' =>  $inv->payment_delivery,
                'delivery_by' =>  $inv->modified_by,
                'delivery_date' =>  date('Y-m-d 10:12:12', strtotime($inv->delivery_date)),
                'delivery_remark' =>  $inv->delivery_remark
            );

           // $this->dashboard->update('invoices', $data, array('id' => $inv->invoice_id, 'commission_user_id' => $inv->commission_user_id));
        }
    }
    
    /*     * ***************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Default function, Load logged in user dashboard stattistics  
     * @param           : null 
     * @return          : null 
     * ********************************************************** */

    public function index() {

         $this->data['total_opd_bill'] = 0;
        $this->data['total_ipd_bill'] = 0;
        $this->data['total_pharmacy_bill'] = 0;
        $this->data['total_investigation_bill'] = 0;
        $this->data['total_pathology_bill'] = 0;
        $this->data['total_radiology_bill'] = 0;

        // Total Income
        $this->data['total_income'] = 0;
        $this->data['total_invoice'] = 0;
        $this->data['total_ipd_invoice'] = 0;
        $this->data['total_opd_patient'] = 0;
        $this->data['total_medicine_invoice'] = 0;

        // Total Expense
        $this->data['total_expense'] = 0;
        $this->data['total_payment'] = 0;
        $this->data['total_medicine_purchase'] = 0;

        // Income Start
        $this->data['get_total_monthly_income'] = $this->dashboard->get_total_monthly_income(date('Y'), date('m'));
        $this->data['jan_total_monthly_income'] = $this->dashboard->get_total_monthly_income(date('Y'), '01');
        $this->data['feb_total_monthly_income'] = $this->dashboard->get_total_monthly_income(date('Y'), '02');
        $this->data['mar_total_monthly_income'] = $this->dashboard->get_total_monthly_income(date('Y'), '03');
        $this->data['apr_total_monthly_income'] = $this->dashboard->get_total_monthly_income(date('Y'), '04');
        $this->data['may_total_monthly_income'] = $this->dashboard->get_total_monthly_income(date('Y'), '05');
        $this->data['jun_total_monthly_income'] = $this->dashboard->get_total_monthly_income(date('Y'), '06');
        $this->data['jul_total_monthly_income'] = $this->dashboard->get_total_monthly_income(date('Y'), '07');
        $this->data['aug_total_monthly_income'] = $this->dashboard->get_total_monthly_income(date('Y'), '08');
        $this->data['sept_total_monthly_income'] = $this->dashboard->get_total_monthly_income(date('Y'), '09');
        $this->data['oct_total_monthly_income'] = $this->dashboard->get_total_monthly_income(date('Y'), '10');
        $this->data['nov_total_monthly_income'] = $this->dashboard->get_total_monthly_income(date('Y'), '11');
        $this->data['dec_total_monthly_income'] = $this->dashboard->get_total_monthly_income(date('Y'), '12');


        $this->data['get_total_monthly_invoice'] = $this->dashboard->get_total_monthly_invoice(date('Y'), date('m'));
        $this->data['jan_total_monthly_invoice'] = $this->dashboard->get_total_monthly_invoice(date('Y'), '01');
        $this->data['feb_total_monthly_invoice'] = $this->dashboard->get_total_monthly_invoice(date('Y'), '02');
        $this->data['mar_total_monthly_invoice'] = $this->dashboard->get_total_monthly_invoice(date('Y'), '03');
        $this->data['apr_total_monthly_invoice'] = $this->dashboard->get_total_monthly_invoice(date('Y'), '04');
        $this->data['may_total_monthly_invoice'] = $this->dashboard->get_total_monthly_invoice(date('Y'), '05');
        $this->data['jun_total_monthly_invoice'] = $this->dashboard->get_total_monthly_invoice(date('Y'), '06');
        $this->data['jul_total_monthly_invoice'] = $this->dashboard->get_total_monthly_invoice(date('Y'), '07');
        $this->data['aug_total_monthly_invoice'] = $this->dashboard->get_total_monthly_invoice(date('Y'), '08');
        $this->data['sept_total_monthly_invoice'] = $this->dashboard->get_total_monthly_invoice(date('Y'), '09');
        $this->data['oct_total_monthly_invoice'] = $this->dashboard->get_total_monthly_invoice(date('Y'), '10');
        $this->data['nov_total_monthly_invoice'] = $this->dashboard->get_total_monthly_invoice(date('Y'), '11');
        $this->data['dec_total_monthly_invoice'] = $this->dashboard->get_total_monthly_invoice(date('Y'), '12');


        $this->data['get_total_monthly_ipd_invoice'] = $this->dashboard->get_total_monthly_ipd_invoice(date('Y'), date('m'));
        $this->data['jan_total_monthly_ipd_invoice'] = $this->dashboard->get_total_monthly_ipd_invoice(date('Y'), '01');
        $this->data['feb_total_monthly_ipd_invoice'] = $this->dashboard->get_total_monthly_ipd_invoice(date('Y'), '02');
        $this->data['mar_total_monthly_ipd_invoice'] = $this->dashboard->get_total_monthly_ipd_invoice(date('Y'), '03');
        $this->data['apr_total_monthly_ipd_invoice'] = $this->dashboard->get_total_monthly_ipd_invoice(date('Y'), '04');
        $this->data['may_total_monthly_ipd_invoice'] = $this->dashboard->get_total_monthly_ipd_invoice(date('Y'), '05');
        $this->data['jun_total_monthly_ipd_invoice'] = $this->dashboard->get_total_monthly_ipd_invoice(date('Y'), '06');
        $this->data['jul_total_monthly_ipd_invoice'] = $this->dashboard->get_total_monthly_ipd_invoice(date('Y'), '07');
        $this->data['aug_total_monthly_ipd_invoice'] = $this->dashboard->get_total_monthly_ipd_invoice(date('Y'), '08');
        $this->data['sept_total_monthly_ipd_invoice'] = $this->dashboard->get_total_monthly_ipd_invoice(date('Y'), '09');
        $this->data['oct_total_monthly_ipd_invoice'] = $this->dashboard->get_total_monthly_ipd_invoice(date('Y'), '10');
        $this->data['nov_total_monthly_ipd_invoice'] = $this->dashboard->get_total_monthly_ipd_invoice(date('Y'), '11');
        $this->data['dec_total_monthly_ipd_invoice'] = $this->dashboard->get_total_monthly_ipd_invoice(date('Y'), '12');


        $this->data['get_total_monthly_opd_patient'] = $this->dashboard->get_total_monthly_opd_patient(date('Y'), date('m'));
        $this->data['jan_total_monthly_opd_patient'] = $this->dashboard->get_total_monthly_opd_patient(date('Y'), '01');
        $this->data['feb_total_monthly_opd_patient'] = $this->dashboard->get_total_monthly_opd_patient(date('Y'), '02');
        $this->data['mar_total_monthly_opd_patient'] = $this->dashboard->get_total_monthly_opd_patient(date('Y'), '03');
        $this->data['apr_total_monthly_opd_patient'] = $this->dashboard->get_total_monthly_opd_patient(date('Y'), '04');
        $this->data['may_total_monthly_opd_patient'] = $this->dashboard->get_total_monthly_opd_patient(date('Y'), '05');
        $this->data['jun_total_monthly_opd_patient'] = $this->dashboard->get_total_monthly_opd_patient(date('Y'), '06');
        $this->data['jul_total_monthly_opd_patient'] = $this->dashboard->get_total_monthly_opd_patient(date('Y'), '07');
        $this->data['aug_total_monthly_opd_patient'] = $this->dashboard->get_total_monthly_opd_patient(date('Y'), '08');
        $this->data['sept_total_monthly_opd_patient'] = $this->dashboard->get_total_monthly_opd_patient(date('Y'), '09');
        $this->data['oct_total_monthly_opd_patient'] = $this->dashboard->get_total_monthly_opd_patient(date('Y'), '10');
        $this->data['nov_total_monthly_opd_patient'] = $this->dashboard->get_total_monthly_opd_patient(date('Y'), '11');
        $this->data['dec_total_monthly_opd_patient'] = $this->dashboard->get_total_monthly_opd_patient(date('Y'), '12');


        $this->data['get_total_monthly_medicine_invoice'] = $this->dashboard->get_total_monthly_medicine_invoice(date('Y'), date('m'));
        $this->data['jan_total_monthly_medicine_invoice'] = $this->dashboard->get_total_monthly_medicine_invoice(date('Y'), '01');
        $this->data['feb_total_monthly_medicine_invoice'] = $this->dashboard->get_total_monthly_medicine_invoice(date('Y'), '02');
        $this->data['mar_total_monthly_medicine_invoice'] = $this->dashboard->get_total_monthly_medicine_invoice(date('Y'), '03');
        $this->data['apr_total_monthly_medicine_invoice'] = $this->dashboard->get_total_monthly_medicine_invoice(date('Y'), '04');
        $this->data['may_total_monthly_medicine_invoice'] = $this->dashboard->get_total_monthly_medicine_invoice(date('Y'), '05');
        $this->data['jun_total_monthly_medicine_invoice'] = $this->dashboard->get_total_monthly_medicine_invoice(date('Y'), '06');
        $this->data['jul_total_monthly_medicine_invoice'] = $this->dashboard->get_total_monthly_medicine_invoice(date('Y'), '07');
        $this->data['aug_total_monthly_medicine_invoice'] = $this->dashboard->get_total_monthly_medicine_invoice(date('Y'), '08');
        $this->data['sept_total_monthly_medicine_invoice'] = $this->dashboard->get_total_monthly_medicine_invoice(date('Y'), '09');
        $this->data['oct_total_monthly_medicine_invoice'] = $this->dashboard->get_total_monthly_medicine_invoice(date('Y'), '10');
        $this->data['nov_total_monthly_medicine_invoice'] = $this->dashboard->get_total_monthly_medicine_invoice(date('Y'), '11');
        $this->data['dec_total_monthly_medicine_invoice'] = $this->dashboard->get_total_monthly_medicine_invoice(date('Y'), '12');

        // Expense 
        $this->data['get_total_monthly_expenditure'] = $this->dashboard->get_total_monthly_expenditure(date('Y'), date('m'));
        $this->data['jan_total_monthly_expenditure'] = $this->dashboard->get_total_monthly_expenditure(date('Y'), '01');
        $this->data['feb_total_monthly_expenditure'] = $this->dashboard->get_total_monthly_expenditure(date('Y'), '02');
        $this->data['mar_total_monthly_expenditure'] = $this->dashboard->get_total_monthly_expenditure(date('Y'), '03');
        $this->data['apr_total_monthly_expenditure'] = $this->dashboard->get_total_monthly_expenditure(date('Y'), '04');
        $this->data['may_total_monthly_expenditure'] = $this->dashboard->get_total_monthly_expenditure(date('Y'), '05');
        $this->data['jun_total_monthly_expenditure'] = $this->dashboard->get_total_monthly_expenditure(date('Y'), '06');
        $this->data['jul_total_monthly_expenditure'] = $this->dashboard->get_total_monthly_expenditure(date('Y'), '07');
        $this->data['aug_total_monthly_expenditure'] = $this->dashboard->get_total_monthly_expenditure(date('Y'), '08');
        $this->data['sept_total_monthly_expenditure'] = $this->dashboard->get_total_monthly_expenditure(date('Y'), '09');
        $this->data['oct_total_monthly_expenditure'] = $this->dashboard->get_total_monthly_expenditure(date('Y'), '10');
        $this->data['nov_total_monthly_expenditure'] = $this->dashboard->get_total_monthly_expenditure(date('Y'), '11');
        $this->data['dec_total_monthly_expenditure'] = $this->dashboard->get_total_monthly_expenditure(date('Y'), '12');

        $this->data['get_total_monthly_payment'] = $this->dashboard->get_total_monthly_payment(date('Y'), date('m'));
        $this->data['jan_total_monthly_payment'] = $this->dashboard->get_total_monthly_payment(date('Y'), '01');
        $this->data['feb_total_monthly_payment'] = $this->dashboard->get_total_monthly_payment(date('Y'), '02');
        $this->data['mar_total_monthly_payment'] = $this->dashboard->get_total_monthly_payment(date('Y'), '03');
        $this->data['apr_total_monthly_payment'] = $this->dashboard->get_total_monthly_payment(date('Y'), '04');
        $this->data['may_total_monthly_payment'] = $this->dashboard->get_total_monthly_payment(date('Y'), '05');
        $this->data['jun_total_monthly_payment'] = $this->dashboard->get_total_monthly_payment(date('Y'), '06');
        $this->data['jul_total_monthly_payment'] = $this->dashboard->get_total_monthly_payment(date('Y'), '07');
        $this->data['aug_total_monthly_payment'] = $this->dashboard->get_total_monthly_payment(date('Y'), '08');
        $this->data['sept_total_monthly_payment'] = $this->dashboard->get_total_monthly_payment(date('Y'), '09');
        $this->data['oct_total_monthly_payment'] = $this->dashboard->get_total_monthly_payment(date('Y'), '10');
        $this->data['nov_total_monthly_payment'] = $this->dashboard->get_total_monthly_payment(date('Y'), '11');
        $this->data['dec_total_monthly_payment'] = $this->dashboard->get_total_monthly_payment(date('Y'), '12');

        $this->data['get_total_monthly_medicine_purchase'] = $this->dashboard->get_total_monthly_medicine_purchase(date('Y'), date('m'));
        $this->data['jan_total_monthly_medicine_purchase'] = $this->dashboard->get_total_monthly_medicine_purchase(date('Y'), '01');
        $this->data['feb_total_monthly_medicine_purchase'] = $this->dashboard->get_total_monthly_medicine_purchase(date('Y'), '02');
        $this->data['mar_total_monthly_medicine_purchase'] = $this->dashboard->get_total_monthly_medicine_purchase(date('Y'), '03');
        $this->data['apr_total_monthly_medicine_purchase'] = $this->dashboard->get_total_monthly_medicine_purchase(date('Y'), '04');
        $this->data['may_total_monthly_medicine_purchase'] = $this->dashboard->get_total_monthly_medicine_purchase(date('Y'), '05');
        $this->data['jun_total_monthly_medicine_purchase'] = $this->dashboard->get_total_monthly_medicine_purchase(date('Y'), '06');
        $this->data['jul_total_monthly_medicine_purchase'] = $this->dashboard->get_total_monthly_medicine_purchase(date('Y'), '07');
        $this->data['aug_total_monthly_medicine_purchase'] = $this->dashboard->get_total_monthly_medicine_purchase(date('Y'), '08');
        $this->data['sept_total_monthly_medicine_purchase'] = $this->dashboard->get_total_monthly_medicine_purchase(date('Y'), '09');
        $this->data['oct_total_monthly_medicine_purchase'] = $this->dashboard->get_total_monthly_medicine_purchase(date('Y'), '10');
        $this->data['nov_total_monthly_medicine_purchase'] = $this->dashboard->get_total_monthly_medicine_purchase(date('Y'), '11');
        $this->data['dec_total_monthly_medicine_purchase'] = $this->dashboard->get_total_monthly_medicine_purchase(date('Y'), '12');



        $this->data['patients'] = $this->dashboard->get_list('patients', array('status' => 1), '', '10', '', 'id', 'DESC');

        $this->data['total_admin'] = $this->dashboard->get_total_admin();
        $this->data['total_doctor'] = $this->dashboard->get_total_doctor();
        $this->data['total_patient'] = $this->dashboard->get_total_patient();
        $this->data['total_accountant'] = $this->dashboard->get_total_accountant();
        $this->data['total_pathologist'] = $this->dashboard->get_total_pathologist();
        $this->data['total_radiologist'] = $this->dashboard->get_total_radiologist();
        $this->data['total_nurse'] = $this->dashboard->get_total_nurse();
        $this->data['total_receptionist'] = $this->dashboard->get_total_receptionist();

        $this->data['notices'] = $this->dashboard->get_notice_list();
        $this->data['events'] = $this->dashboard->get_event_list();

        $this->layout->title($this->lang->line('dashboard') . ' | ' . TITLE);
        $this->layout->view('dashboard', $this->data);
    }

    public function switchLang_mm($language = "") {
        $this->session->set_userdata('site_lang', $language);
        $url = $_SERVER['HTTP_REFERER'];
        redirect($url);
    }

    public function get_navbar_toggle() {
        $user = $this->dashboard->get_single('users', array('id' => $this->session->userdata('user_id')));
        if ($user->toggle_btn == 1) {
            $this->dashboard->update('users', array('toggle_btn' => 0), array('id' => $this->session->userdata('user_id')));
            $this->session->set_userdata('toggle_btn', 0);
        } else {
            $this->dashboard->update('users', array('toggle_btn' => 1), array('id' => $this->session->userdata('user_id')));
            $this->session->set_userdata('toggle_btn', 1);
        }
    }

    public function get_top_navbar() {
        if ($this->input->post('status') == 1) {
            $this->dashboard->update('users', array('top_nav' => 1), array('id' => $this->session->userdata('user_id')));
            $this->session->set_userdata('top_nav', 1);
        } else {
            $this->dashboard->update('users', array('top_nav' => 0), array('id' => $this->session->userdata('user_id')));
            $this->session->set_userdata('top_nav', 0);
        }
    }

    public function get_sidebar_nav() {
        if ($this->input->post('status') == 1) {
            $this->dashboard->update('users', array('sidebar_nav' => 1), array('id' => $this->session->userdata('user_id')));
            $this->session->set_userdata('sidebar_nav', 1);
        } else {
            $this->dashboard->update('users', array('sidebar_nav' => 0), array('id' => $this->session->userdata('user_id')));
            $this->session->set_userdata('sidebar_nav', 0);
        }
    }
}
