<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Mimsms {

    public $apiKey = "";
    public $type = "";
    public $senderId = "";
    public $url = "https://esms.mimsms.com/smsapi";

    function __construct() {

        $ci = &get_instance();
        $ci->db->select('S.*');
        $ci->db->from('sms_settings AS S');
        $ci->db->where('S.mimsms_status', '1');
        $setting = $ci->db->get()->row();

        $this->apiKey = isset($setting) && $setting->mimsms_api_key ? $setting->mimsms_api_key : '';
        $this->type = isset($setting) && $setting->mimsms_type ? $setting->mimsms_type: '';
        $this->senderId = isset($setting) && $setting->mimsms_sender_id ? $setting->mimsms_sender_id : '';
    }

    function sendMimSms($to, $message) {
        $data = array(
            'api_key' => $this->apiKey,
            'type' => $this->type,
            'contacts' => $to,
            'senderid' => $this->senderId,
            'msg' => $message
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }
}
