<div class="table-wrap">
    <div class="table-responsive">
        <table class="table table-sm text-white">
            <tbody>
                <tr>
                    <td><?php echo $this->lang->line('expenditure_head'); ?></td>
                    <td><?php echo $expenditure->expenditure_head; ?></td>
                    <td><?php echo $this->lang->line('name'); ?></td>
                    <td><?php echo $expenditure->name; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('reference'); ?></td>
                    <td><?php echo $expenditure->reference; ?></td>
                    <td><?php echo $this->lang->line('invoice_no'); ?></td>
                    <td><?php echo $expenditure->invoice_no; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('method'); ?></td>
                    <td><?php echo $this->lang->line($expenditure->payment_method); ?></td>
                    <td><?php echo $this->lang->line('bank_name'); ?></td>
                    <td><?php echo $expenditure->bank_name; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('cheque_no'); ?></td>
                    <td><?php echo $expenditure->cheque_no; ?></td>
                    <td><?php echo $this->lang->line('amount'); ?></td>
                    <td><?php echo $expenditure->amount; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('date'); ?></td>
                    <td><?php echo date('d/m/Y h:i A', strtotime($expenditure->date)); ?></td>
                    <td><?php echo $this->lang->line('status'); ?></td>
                    <td>
                        <?php echo $expenditure->status ? '<span class="badge badge-success">' . $this->lang->line('active') . '</span>' : '<span class="badge badge-danger">' . $this->lang->line('in_active') . '</span>'; ?>
                    </td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('attachment'); ?></td>
                    <td>
                        <?php if ($expenditure->attachment) { ?>
                            <a target="_blank" href="<?php echo UPLOAD_PATH; ?>attachment/<?php echo $expenditure->attachment; ?>" class="btn btn-success btn-xs"><i class="fa fa-download"></i> <?php echo $this->lang->line('download'); ?></a>
                        <?php } ?>
                    </td>
                    <td><?php echo $this->lang->line('remark'); ?></td>
                    <td><?php echo $expenditure->note; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('created_by'); ?></td>
                    <td><?php echo $expenditure->created_by; ?></td>
                    <td><?php echo $this->lang->line('date'); ?></td>
                    <td><?php echo date('d F, Y h:i A', strtotime($expenditure->created_at)); ?></td>
                </tr>
                <?php if ($this->session->userdata('role_id') == SUPER_ADMIN || !empty(custom_permission('modified_by'))) { ?>
                    <tr>
                        <td><?php echo $this->lang->line('modified_by'); ?></td>
                        <td><?php echo $expenditure->modified_by; ?></td>
                        <td><?php echo $this->lang->line('date'); ?></td>
                        <td><?php echo $expenditure->modified_by ? date('d F, Y h:i A', strtotime($expenditure->modified_at)) : ''; ?>
                        </td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>