<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item"><a href="<?php echo site_url('diagnostic/report'); ?>"><?php echo $this->lang->line('report'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('create'); ?> <?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-plus"></i></span>
            <?php echo $this->lang->line('create'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <?php echo form_open(site_url('diagnostic/report/save'), array('name' => 'add', 'id' => 'add', 'class' => 'form-horizontal form-label-left'), ''); ?>
                
                <!-- Patient and Doctor Information -->
                <div class="row mb-3">
                    <div class="col-md-12">
                        <div class="info-list">
                            <div class="info-item">
                                <span class="info-label"><?php echo $this->lang->line('patient'); ?>:</span>
                                <?php echo $patient_info->name; ?>
                            </div>
                            <div class="info-item">
                                <span class="info-label"><?php echo $this->lang->line('patient_id'); ?>:</span>
                                <?php echo $patient_info->patient_unique_id; ?>
                            </div>
                            <div class="info-item">
                                <span class="info-label"><?php echo $this->lang->line('age'); ?>:</span>
                                <?php echo $patient_info->age; ?>y
                            </div>
                            <div class="info-item">
                                <span class="info-label"><?php echo $this->lang->line('doctor'); ?> <?php echo $this->lang->line('name'); ?>:</span>
                                <input type="text" class="form-control-plaintext" id="doctor_name" value="<?php echo isset($doctor_info->name) ? $doctor_info->name : ''; ?>" readonly>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Test Sections -->
                <?php
                $current_group = '';
                if (isset($templates) && !empty($templates)) {
                    foreach ($templates as $obj) {
                        // Start new group section if group changes
                        if ($current_group != $obj->group) {
                            if ($current_group != '') {
                                echo '</div>'; // Close previous group section
                            }
                            $current_group = $obj->group;
                            echo '<div class="section mb-4">';
                            echo '<div class="label h5">' . $obj->group . '</div>';
                        }
                ?>
                        <div class="row mb-3">
                            <div class="col-md-12">
                                <div class="test-item">                                    
                                    <div class="input-row">
                                        <div class="investigation"><?php echo $obj->investigation; ?></div>
                                        <input type="text" 
                                               class="form-control input-box" 
                                               name="result[<?php echo $obj->id; ?>]" 
                                               placeholder="<?php echo $this->lang->line('input_result'); ?>">
                                        <select class="form-control select2 select-box" 
                                                name="result_option[<?php echo $obj->id; ?>]" 
                                                id="result_option_<?php echo $obj->id; ?>">
                                            <option value=""><?php echo $this->lang->line('select_option'); ?></option>
                                            <?php 
                                            $options = $this->report->get_result_options($obj->test_id);
                                            if (!empty($options)) {
                                                foreach ($options as $option) { 
                                            ?>
                                                <option value="<?php echo $option->id; ?>">
                                                    <?php echo $option->option_name; ?>
                                                </option>
                                            <?php 
                                                }
                                            }
                                            ?>
                                        </select>
                                        <div class="normal_value"><?php echo $obj->normal_value; ?></div>
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
                <?php
                    }
                    echo '</div>'; // Close last group section
                }
                ?>

                <div class="row mt-4">
                    <div class="col-sm-12">
                        <input type="hidden" name="patient_id" value="<?php echo $patient_id; ?>">
                        <input type="hidden" name="invoice_id" value="<?php echo $invoice_id; ?>">
                        <button type="submit" class="btn btn-gradient-primary"><?php echo $this->lang->line('save'); ?></button>
                        <button type="button" class="btn btn-gradient-danger" onclick="window.location.href='<?php echo site_url('diagnostic/report/generate/' . $invoice_id); ?>'"><?php echo $this->lang->line('cancel'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </section>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<style>
.info-list {
    display: flex;
    flex-direction: row;
    gap: 10px;
}
.info-item {
    display: flex;
    align-items: center;
    gap: 10px;
}
.info-label {
    font-weight: 500;
    min-width: 120px;
}
.form-control-plaintext {
    border: none;
    background: transparent;
    padding: 0;
    margin: 0;
    outline: none;
}

.patient-info, .doctor-info {
    padding: 8px;
    background: #f8f9fa;
    border-radius: 4px;
    margin-bottom: 10px;
}

.label {
    font-weight: bold;
    color: #333;
    margin-right: 5px;
}

.section {
    border: 1px solid #ddd;
    padding: 5px;
    margin-bottom: 5px;
    border-radius: 4px;
}

.test-item {
    padding: 5px;
    background: #fff;
    border-radius: 4px;
}

.test-name {
    font-weight: 500;
    margin-bottom: 5px;
}

.input-row {
    display: flex;
    gap: 10px;
    margin-bottom: 0px;
    align-items: center;
}

.input-box {
    width: 100px !important;
    flex: none;
}

.select-box {
    width: 200px;
}

.investigation {
    font-size: 16px;
    font-weight: 500;
    min-width: 200px;
}

.normal_value {
    font-size: 16px;
    color: #2c3e50;
    min-width: 150px;
    text-align: right;
}


.section .label {
    color: #2c3e50;
    font-size: 1.1em;
    margin-bottom: 15px;
    padding-bottom: 5px;
    border-bottom: 1px solid #eee;
}
</style>

<script>
$(document).ready(function() {
    $('.select2').select2({
        width: '100%'
    });
});
</script> 