<!DOCTYPE html>
<html>

<head>
    <title>Report Print</title>
    <style>
        body {
            font-family: "Times New Roman", serif;
            font-size: 13px;
            margin: 0;
            padding: 0;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            margin-top: 40px;
        }

        .header-table {
            width: 100%;
            border: none;
            margin-bottom: 0;
        }

        .header-table td {
            border: none;
            vertical-align: middle;
        }

        .report-title {
            text-align: center;
            font-size: 22px;
            font-weight: bold;
            letter-spacing: 1px;
        }

        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 0;
        }

        .info-table td {
            font-size: 15px;
            padding: 4px 8px 4px 0;
            border: none;
            vertical-align: top;
        }

        .info-table tr {
            border-bottom: 1px dotted #000;
        }

        .info-label {
            font-weight: bold;
            width: 18%;
            white-space: nowrap;
        }

        .info-sep {
            width: 1%;
            font-weight: bold;
        }

        .info-value {
            font-weight: bold;
            text-transform: capitalize;
        }

        .test-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        .test-table th {
            font-weight: bold;
            font-size: 16px;
            text-align: center;
            border: 1px solid #000;
            padding: 6px 0;
            background: #fff;
        }

        .test-table td {
            font-size: 15px;
            padding: 6px 8px;
            border: none;
            vertical-align: middle;
        }

        .test-table tr.data-row {
            border-bottom: 2px dotted #000;
        }

        .test-param {
            text-align: left;
        }

        .test-result {
            text-align: center;
            font-weight: bold;
        }

        .test-normal {
            text-align: right;
        }

        @media print {
            body {
                font-size: 12px;
            }
            
            .main_body {
                margin-top: 20px;
            }
        }
    </style>
    
    <?php if (isset($this->global_setting->custom_css) && $this->global_setting->custom_css) { ?>
    <style>
        <?php echo $this->global_setting->custom_css; ?>
    </style>
    <?php } ?>
</head>

<body>
<div class="page">
    <div class="main_body">
        <table class="header-table">
            <tr>
                <td style="width: 20%; text-align:left;">
                    <img src="<?php echo defined('IMG_URL') ? IMG_URL : base_url('assets/images/'); ?>report_barcode.png" alt="Barcode" height="40">
                </td>
                <td style="width: 60%;">
                    <div class="report-title">
                        BIO-CHEMISTRY REPORT
                    </div>
                </td>
                <td style="width: 20%; text-align:right;">
                    <img src="<?php echo defined('IMG_URL') ? IMG_URL : base_url('assets/images/'); ?>report_barcode.png" alt="Barcode" height="40">
                </td>
            </tr>
        </table>
        <table class="info-table">
            <tr>
                <td class="info-label">ID No:</td>
                <td class="info-sep">:</td>
                <td class="info-value"><?php echo isset($template->patient_unique_id) ? $template->patient_unique_id : 'N/A'; ?></td>
                <td class="info-label">Invoice no:</td>
                <td class="info-sep">:</td>
                <td><?php echo isset($template->custom_invoice_id) ? $template->custom_invoice_id : 'N/A'; ?></td>
            </tr>
            <tr>
                <td class="info-label">Name</td>
                <td class="info-sep">:</td>
                <td class="info-value"><?php echo isset($template->patient) ? $template->patient : 'N/A'; ?></td>
                <td class="info-label">Received Date:</td>
                <td class="info-sep">:</td>
                <td><?php echo isset($template->billcreate) ? date('d/m/Y', strtotime($template->billcreate)) : 'N/A'; ?></td>
            </tr>
            <tr>
                <td class="info-label">Age:</td>
                <td class="info-sep">:</td>
                <td><?php echo isset($template->dob) ? calculate_age($template->dob) : 'N/A'; ?></td>
                <td class="info-label">Specimen:</td>
                <td class="info-sep">:</td>
                <td><?php echo isset($template->specimen) ? $template->specimen : 'N/A'; ?></td>
            </tr>
            <tr>
                <td class="info-label">Gender:</td>
                <td class="info-sep">:</td>
                <td><?php if (isset($template->gender) && $template->gender) { echo $this->lang->line($template->gender); } else { echo 'N/A'; } ?></td>
                <td class="info-label">Mobile:</td>
                <td class="info-sep">:</td>
                <td><?php echo isset($template->mobile) ? $template->mobile : 'N/A'; ?></td>
            </tr>
            <tr>
                <td class="info-label">Refd. By</td>
                <td class="info-sep">:</td>
                <td colspan="4">
                    <?php 
                    if (isset($template->self) && $template->self) {
                        echo 'Self';
                    } elseif (isset($template->ref_dr_id) && $template->ref_dr_id > 0) {
                        echo $template->doctor . ', ' . $template->specialist;
                    } elseif (isset($template->ref_dr_name)) {
                        echo $template->ref_dr_name;
                    } else {
                        echo 'N/A';
                    }
                    ?>
                </td>
            </tr>
        </table>
        <table class="test-table">
            <thead>
                <tr>
                    <th class="test-param">Test Parameter</th>
                    <th class="test-result">Result</th>
                    <th class="test-normal">Normal Value</th>
                </tr>
            </thead>
            <tbody>
            <?php 
            if (isset($test_results) && is_array($test_results) && !empty($test_results)) {
                foreach ($test_results as $result) { 
                    $option_name = '';
                    if (isset($result['result_option']) && $result['result_option']) {
                        $option = $this->db->get_where('diagnostic_tests_option', array('id' => $result['result_option']))->row();
                        $option_name = $option ? $option->option_name : '';
                    }
            ?>
                <tr class="data-row">
                    <td class="test-param"><?php echo isset($result['investigation_name']) ? $result['investigation_name'] : 'N/A'; ?></td>
                    <td class="test-result">
                        <?php echo isset($result['result']) ? $result['result'] : 'N/A'; ?>
                        <?php if ($option_name) { ?>
                            <br><small>(<?php echo $option_name; ?>)</small>
                        <?php } ?>
                    </td>
                    <td class="test-normal"><?php echo isset($result['normal_value']) ? $result['normal_value'] : 'N/A'; ?></td>
                </tr>
            <?php 
                }
            } else { ?>
                <tr><td colspan="3" style="text-align:center;">No test results available</td></tr>
            <?php } ?>
            </tbody>
        </table>
    </div>
</div>

<script>
    window.onload = function() {
        setTimeout(function() { window.print(); }, 500);
    }
</script>
</body>
</html> 