<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Doctor_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_doctor_list($limit, $offset, $keyword, $department_id, $designation_id, $count) {
        $this->db->select('E.*, D.name AS department, DE.name AS designation, R.name as role, U.role_id, U.device_id');
        $this->db->from('employees AS E');
        $this->db->join('departments AS D', 'D.id = E.department_id', 'left');
        $this->db->join('designations AS DE', 'DE.id = E.designation_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->join('roles AS R', 'R.id = U.role_id', 'left');

        if ($this->session->userdata('role_id') != SUPER_ADMIN) {
            $this->db->where('U.role_id !=', 1);
        }

        if ($keyword) {
            $this->db->group_start();
            $this->db->like('E.phone', $keyword);
            $this->db->or_like('E.name', $keyword, 'both');
            $this->db->or_like('E.bn_name', $keyword, 'both');
            $this->db->or_like('E.gender', $keyword);
            $this->db->or_like('E.religion', $keyword);
            $this->db->or_like('E.blood_group', $keyword);
            $this->db->or_like('E.marital_status', $keyword);
            $this->db->or_like('E.present_address', $keyword, 'both');
            $this->db->or_like('E.permanent_address', $keyword, 'both');
            $this->db->or_like('D.name', $keyword, 'both');
            $this->db->or_like('DE.name', $keyword, 'both');
            $this->db->group_end();
        }
        if ($department_id) {
            $this->db->where('E.department_id', $department_id);
        }
        if ($designation_id) {
            $this->db->where('E.designation_id', $designation_id);
        }
        $this->db->where('U.role_id', DOCTOR);
        $this->db->order_by('E.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_doctor($id) {
        $this->db->select('E.*, D.name AS department, DE.name AS designation, U.username, U.temp_password, U.device_id, U.sbiz_id, U.role_id, C.name as created_by, M.name as modified_by');
        $this->db->from('employees AS E');
        $this->db->join('departments AS D', 'D.id = E.department_id', 'left');
        $this->db->join('designations AS DE', 'DE.id = E.designation_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->join('roles AS R', 'R.id = U.role_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = E.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = E.modified_by', 'left');
        if ($this->session->userdata('role_id') != SUPER_ADMIN) {
            $this->db->where('U.role_id !=', 1);
        }
        $this->db->where('E.id', $id);
        return $this->db->get()->row();
    }

    function duplicate_check($username, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('username', $username);
        return $this->db->get('users')->num_rows();
    }

    function duplicate_check_phone($phone, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('phone', $phone);
        return $this->db->get('employees')->num_rows();
    }
}
