<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('anesthetist'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_anesthetist'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('doctor/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(EDIT, 'doctor', 'anesthetist')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user-md font-30 mr-10"></i>
                            <?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('anesthetist'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'doctor', 'anesthetist')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('doctor/anesthetist'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('anesthetist'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('doctor/anesthetist/edit/' . $anesthetist->user_id), array('name' => 'edit', 'id' => 'edit', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-5 mb-10">
                            <label for="name"><?php echo $this->lang->line('name'); ?></label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($anesthetist->name) ?  $anesthetist->name : ''; ?>" placeholder="<?php echo $this->lang->line('name'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('name'); ?>
                            </small>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="bn_name"><?php echo $this->lang->line('bn_name'); ?></label>
                            <input type="text" class="form-control" name="bn_name" id="bn_name" value="<?php echo isset($anesthetist->bn_name) ?  $anesthetist->bn_name : ''; ?>" placeholder="<?php echo $this->lang->line('bn_name'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="charge"><?php echo $this->lang->line('charge'); ?></label>
                            <input type="text" class="form-control" name="charge" id="charge" value="<?php echo isset($anesthetist->charge) ?  $anesthetist->charge : ''; ?>" placeholder="<?php echo $this->lang->line('charge'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="charge" class="form-text text-muted">
                                <?php echo form_error('charge'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="bmdc_reg_no"><?php echo $this->lang->line('bmdc_reg_no'); ?></label>
                            <input type="text" class="form-control" name="bmdc_reg_no" id="bmdc_reg_no" value="<?php echo isset($anesthetist->bmdc_reg_no) ?  $anesthetist->bmdc_reg_no : ''; ?>" placeholder="<?php echo $this->lang->line('bmdc_reg_no'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="employee_type"><?php echo $this->lang->line('employee'); ?> <?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select" name="employee_type" id="employee_type" required>
                                <option value="anesthetist" <?php echo isset($anesthetist->employee_type) && $anesthetist->employee_type == 'anesthetist' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('anesthetist'); ?></option>
                                <option value="other" <?php echo isset($anesthetist->employee_type) && $anesthetist->employee_type == 'other' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('other'); ?></option>
                                <option value="consultant" <?php echo isset($anesthetist->employee_type) && $anesthetist->employee_type == 'consultant' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('consultant'); ?></option>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="employee_type" class="form-text text-muted">
                                <?php echo form_error('employee_type'); ?>
                            </small>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="specialist"><?php echo $this->lang->line('specialist'); ?></label>
                            <input type="text" class="form-control" name="specialist" id="specialist" value="<?php echo isset($anesthetist->specialist) ?  $anesthetist->specialist : ''; ?>" placeholder="<?php echo $this->lang->line('specialist'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="department_id"><?php echo $this->lang->line('department'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <select class="form-control custom-select select2" name="department_id" id="department_id" onchange="get_designation(this.value)">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($departments as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($anesthetist->department_id) && $anesthetist->department_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('department_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="designation_id"><?php echo $this->lang->line('designation'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <select class="form-control custom-select select2" name="designation_id" id="designation_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($designations as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($anesthetist->designation_id) && $anesthetist->designation_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('designation_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="phone"><?php echo $this->lang->line('phone'); ?></label>
                            <input type="number" class="form-control" name="phone" id="phone" value="<?php echo isset($anesthetist->phone) ?  $anesthetist->phone : ''; ?>" placeholder="<?php echo $this->lang->line('phone'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('phone'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="national_id"><?php echo $this->lang->line('national_id'); ?></label>
                            <input type="number" class="form-control" name="national_id" id="national_id" value="<?php echo isset($anesthetist->national_id) ?  $anesthetist->national_id : ''; ?>" placeholder="<?php echo $this->lang->line('national_id'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="birth_date"><?php echo $this->lang->line('birth_date'); ?></label>
                            <input type="text" class="form-control" name="dob" id="dob" value="<?php echo isset($anesthetist->dob) ?  date('d/m/Y', strtotime($anesthetist->dob)) : ''; ?>" placeholder="<?php echo $this->lang->line('birth_date'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('birth_date'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="joining_date"><?php echo $this->lang->line('join_date'); ?></label>
                            <input type="text" class="form-control" name="joining_date" id="joining_date" value="<?php echo isset($anesthetist->joining_date) ?  date('d/m/Y', strtotime($anesthetist->joining_date)) : ''; ?>" placeholder="<?php echo $this->lang->line('join_date'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('join_date'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="gender"><?php echo $this->lang->line('gender'); ?></label>
                            <select class="form-control custom-select" name="gender" id="gender">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $genders = get_genders(); ?>
                                <?php foreach ($genders as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($anesthetist->gender) && $anesthetist->gender == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('gender'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="religion"><?php echo $this->lang->line('religion'); ?></label>
                            <select class="form-control custom-select" name="religion" id="religion">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $religions = get_religion(); ?>
                                <?php foreach ($religions as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($anesthetist->religion) && $anesthetist->religion == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('religion'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="blood_group"><?php echo $this->lang->line('blood_group'); ?></label>
                            <select class="form-control custom-select" name="blood_group" id="blood_group">
                                <option selected><?php echo $this->lang->line('select'); ?></option>
                                <?php $bloods = get_blood_group(); ?>
                                <?php foreach ($bloods as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($anesthetist->blood_group) && $anesthetist->blood_group == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="marital_status"><?php echo $this->lang->line('marital_status'); ?></label>
                            <select class="form-control custom-select" name="marital_status" id="marital_status">
                                <option selected><?php echo $this->lang->line('select'); ?></option>
                                <?php $marital_status = get_marital_status(); ?>
                                <?php foreach ($marital_status as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($anesthetist->marital_status) && $anesthetist->marital_status == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('present'); ?> <?php echo $this->lang->line('address'); ?></span>
                                </div>
                                <textarea class="form-control" name="present_address" id="present_address" aria-label="<?php echo $this->lang->line('present'); ?> <?php echo $this->lang->line('address'); ?>"><?php echo isset($anesthetist->present_address) ?  $anesthetist->present_address : ''; ?></textarea>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('permanent'); ?> <?php echo $this->lang->line('address'); ?></span>
                                </div>
                                <textarea class="form-control" name="permanent_address" id="permanent_address" aria-label="<?php echo $this->lang->line('permanent'); ?> <?php echo $this->lang->line('address'); ?>"><?php echo isset($anesthetist->permanent_address) ?  $anesthetist->permanent_address : ''; ?></textarea>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="role_id"><?php echo $this->lang->line('role'); ?></label>
                            <select class="form-control custom-select" name="role_id" id="role_id" required>
                                <option value="<?php echo DOCTOR; ?>" <?php echo isset($anesthetist->role_id) && $anesthetist->role_id == 'DOCTOR' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('doctor'); ?></option>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('role_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="email"><?php echo $this->lang->line('email'); ?></label>
                            <input type="text" class="form-control" name="email" id="email" value="<?php echo isset($anesthetist->email) ?  $anesthetist->email : ''; ?>" placeholder="<?php echo $this->lang->line('email'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="username"><?php echo $this->lang->line('username'); ?></label>
                            <input type="text" class="form-control" name="username" id="username" value="<?php echo isset($anesthetist->username) ?  $anesthetist->username : ''; ?>" placeholder="<?php echo $this->lang->line('username'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('username'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="device_id "><?php echo $this->lang->line('device_id'); ?></label>
                            <input type="number" class="form-control" name="device_id" id="device_id" value="<?php echo isset($anesthetist->device_id) ?  $anesthetist->device_id : ''; ?>" placeholder="<?php echo $this->lang->line('device_id'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="sort_by"><?php echo $this->lang->line('sort_by'); ?></label>
                            <input type="number" class="form-control" name="sort_by" id="sort_by" value="<?php echo isset($anesthetist->sort_by) ?  $anesthetist->sort_by : ''; ?>" placeholder="<?php echo $this->lang->line('sort_by'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="photo"><?php echo $this->lang->line('photo'); ?></label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                        <input type="file" name="photo">
                                        <input type="hidden" name="prev_photo" id="prev_photo" value="<?php echo $anesthetist->photo; ?>" />
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-1 mb-10">
                            <div class="avatar">
                                <?php if ($anesthetist->photo != '') { ?>
                                    <img class="avatar-img rounded" src="<?php echo UPLOAD_PATH; ?>employee-photo/<?php echo $anesthetist->photo; ?>" alt="<?php echo $anesthetist->name; ?>" />
                                <?php } elseif ($anesthetist->gender == 'male') { ?>
                                    <img class="avatar-img rounded" src="<?php echo IMG_URL; ?>male.png" alt="male" />
                                <?php } else { ?>
                                    <img class="avatar-img rounded" src="<?php echo IMG_URL; ?>female.png" alt="female" />
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="signature"><?php echo $this->lang->line('signature'); ?></label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                        <input type="file" name="signature">
                                        <input type="hidden" name="prev_signature" id="prev_signature" value="<?php echo $anesthetist->signature; ?>" />
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-1 mb-10">
                            <div class="avatar">
                                <?php if ($anesthetist->signature != '') { ?>
                                    <img class="avatar-img rounded" src="<?php echo UPLOAD_PATH; ?>employee-signature/<?php echo $anesthetist->signature; ?>" alt="<?php echo $anesthetist->name; ?>" />
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="resume"><?php echo $this->lang->line('resume'); ?></label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                        <input type="file" name="resume">
                                        <input type="hidden" name="prev_resume" id="prev_resume" value="<?php echo $anesthetist->resume; ?>" />
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-1 mb-10">
                            <div class="avatar mt-40 ml-10">
                                <?php if ($anesthetist->resume != '') { ?>
                                    <a href="<?php echo UPLOAD_PATH; ?>employee-resume/<?php echo $anesthetist->resume; ?>"><i class="fa fa-download" aria-hidden="true"></i></a>
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-4 mt-10">
                            <div class="custom-control custom-checkbox checkbox-primary">
                                <input type="checkbox" class="custom-control-input" name="is_view_on_web" id="is_view_on_web" value="1" <?php echo $anesthetist->is_view_on_web ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="is_view_on_web"><?php echo $this->lang->line('is_view_on_web'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-4 mt-10">
                            <div class="custom-control custom-checkbox checkbox-cyan">
                                <input type="checkbox" class="custom-control-input" name="status" id="status" value="1" <?php echo $anesthetist->status ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="status"><?php echo $this->lang->line('status'); ?></label>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="id" id="id" value="<?php echo $anesthetist->user_id; ?>" />
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('doctor/anesthetist'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Daterangepicker -->
<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>

<script>
    $(".select2").select2();
    $('#dob, #joining_date').datepicker({
        dateFormat: "yy/mm/dd",
        showOtherMonths: true,
        selectOtherMonths: true,
        autoclose: true,
        changeMonth: true,
        changeYear: true,
        orientation: "bottom"
    }).datepicker("setDate", "now");
</script>

<script>
    function get_designation(department_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_department_by_designation'); ?>",
            data: {
                department_id: department_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#designation_id').html(response);
                }
            }
        });
    };
</script>