<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class History_Model extends MY_Model
{

    function __construct()
    {
        parent::__construct();
    }

    public function get_employee_list()
    {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_history_list($limit, $offset, $keyword, $create_form_date, $create_to_date, $followup_form_date, $followup_to_date, $status, $gender, $category_id, $created_by, $count)
    {
        $this->db->select('FH.*, FC.name as followup_category, FC.day, P.patient_unique_id,P.name as patient, P.phone,P.dob,P.gender,P.address,P.guardian_name');
        $this->db->from('followup_histories AS FH');
        $this->db->join('followup_categories AS FC', 'FC.id = FH.category_id', 'left');
        $this->db->join('patients AS P', 'P.user_id = FH.patient_id', 'left');
        if ($keyword) {
            $this->db->where('P.patient_unique_id', $keyword);
        }
        if ($create_form_date && $create_to_date) {
            $this->db->where("DATE(FH.create_date) BETWEEN '$create_form_date' AND '$create_to_date'");
        }
        if ($followup_form_date && $followup_to_date) {
            $this->db->where("DATE(FH.followup_date) BETWEEN '$followup_form_date' AND '$followup_to_date'");
        }
        if ($status == 1) {
            $this->db->where('FH.status', $status);
        }
        if ($status == 2) {
            $this->db->where('FH.status', 0);
        }
        if ($gender) {
            $this->db->where('P.gender', $gender);
        }
        if ($category_id) {
            $this->db->where('FH.category_id', $category_id);
        }
        if ($created_by) {
            $this->db->where('FH.created_by', $created_by);
        }
        $this->db->order_by('FH.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }
}
