<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('category'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('category'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('followup/left-side'); ?>
        <!-- col-xl-9 -->
        <div class="col-lg-9">
            <div class="row">
                <!-- col-xl-12 -->
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between">
                            <?php if (has_permission(VIEW, 'followup', 'category')) { ?>
                                <h6 class="card-header d-flex align-items-center">
                                    <i class="fa fa-bullhorn font-30 mr-10"></i>
                                    <?php echo $this->lang->line('category'); ?> <?php echo $this->lang->line('list'); ?>
                                </h6>
                            <?php } ?>
                            <?php if (has_permission(ADD, 'followup', 'category')) { ?>
                                <div class="align-items-center">
                                    <a href="<?php echo site_url('followup/category/add'); ?>" class="btn btn-xs btn-primary">
                                        <i class="fa fa-plus font-12 mr-5"></i>
                                        <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('category'); ?>
                                    </a>
                                </div>
                            <?php } ?>
                        </div>
                        <div class="card-body">
                            <div class="table-wrap">
                                <div class="table-responsive">
                                    <table class="table table-sm mb-0">
                                        <thead>
                                            <tr>
                                                <th><?php echo $this->lang->line('sl_no'); ?></th>
                                                <th><?php echo $this->lang->line('name'); ?></th>
                                                <th><?php echo $this->lang->line('day'); ?></th>
                                                <th><?php echo $this->lang->line('sort_by'); ?></th>
                                                <th><?php echo $this->lang->line('status'); ?></th>
                                                <th style="width: 18%;"><?php echo $this->lang->line('action'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if (isset($categories) && !empty($categories)) { ?>
                                                <?php foreach ($categories as $obj) { ?>
                                                    <tr>
                                                        <td><?php echo $sl_count; ?></td>
                                                        <td><?php echo $obj->name; ?></td>
                                                        <td><?php echo $obj->day; ?></td>
                                                        <td><?php echo $obj->sort_by; ?></td>
                                                        <td><?php echo $obj->status ? '<span class="badge badge-success">' .  $this->lang->line('active') . '</span>' : '<span class="badge badge-danger">' .  $this->lang->line('in_active') . '</span>'; ?></td>
                                                        <td>
                                                            <?php if (has_permission(VIEW, 'followup', 'category')) { ?>
                                                                <button type="button" onclick="get_view_modal(<?php echo $obj->id; ?>);" data-toggle="modal" data-target=".viewModalCenter" class="btn btn-primary btn-xs">
                                                                    <i class="fa fa-eye"></i>
                                                                </button>
                                                            <?php } ?>
                                                            <?php if (has_permission(EDIT, 'followup', 'category')) { ?>
                                                                <a class="btn btn-success btn-xs" href="<?php echo site_url('followup/category/edit/' . $obj->id); ?>"> <i class="fa fa-pencil"></i> </a>
                                                            <?php } ?>
                                                            <?php if (has_permission(DELETE, 'followup', 'category')) { ?>
                                                                <a class="btn btn-danger btn-xs" href="<?php echo site_url('followup/category/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash"></i> </a>
                                                            <?php } ?>
                                                        </td>
                                                    </tr>
                                                    <?php $sl_count++; ?>
                                                <?php } ?>
                                            <?php } else { ?>
                                                <tr class="text-center">
                                                    <td colspan="6"><?php echo $this->lang->line('no_data_found'); ?></td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <!-- Card Footer -->
                        <?php if ($this->pagination->create_links()) { ?>
                            <div class="card-footer justify-content-end">
                                <?php echo $this->pagination->create_links(); ?>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div><!-- /Row -->
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<div class="modal fade viewModalCenter" tabindex="-1" role="dialog" aria-labelledby="viewModalCenter" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary">
                <h5 class="modal-title text-white"><?php echo $this->lang->line('category'); ?> <?php echo $this->lang->line('info'); ?></h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body modal_data bg-gradient-secondary"></div>
        </div>
    </div>
</div>

<script type="text/javascript">
    function get_view_modal(id) {
        $('.modal_data').html('<p style="padding: 20px;"><p style="padding: 20px;text-align:center;"><img src="<?php echo IMG_URL; ?>loader.gif" /></p>');
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('followup/category/get_single_category'); ?>",
            data: {
                id: id
            },
            success: function(response) {
                if (response) {
                    $('.modal_data').html(response);
                }
            }
        });
    }
</script>


<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
</script>