<!--Add Appointment Modal-->
<div class="modal fade" id="addPaytentModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content modal-media-content">
            <div class="modal-header">
                <h5 class="modal-title mr-30"><?php echo $this->lang->line('add') . " " . $this->lang->line('patient'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <?php echo form_open_multipart(site_url('followup/patient/add'), array('name' => 'addPatientForm', 'id' => 'addPatientForm', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
            <div class="modal-body">
                <div class="form-row">
                    <div class="col-md-5 mb-10">
                        <label for="add_name"><?php echo $this->lang->line('name'); ?> <span class="required">*</span></label>
                        <input type="text" class="form-control" name="name" id="add_name" value="<?php echo isset($name) ?  $name : ''; ?>" placeholder="<?php echo $this->lang->line('name'); ?>" required autocomplete="off">
                    </div>
                    <div class="col-md-3 mb-10">
                        <label for="add_gender"><?php echo $this->lang->line('gender'); ?> <span class="required">*</span></label>
                        <select class="form-control custom-select" name="gender" id="add_gender" required>
                            <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                            <?php $genders = get_genders(); ?>
                            <?php foreach ($genders as $key => $value) { ?>
                                <option value="<?php echo $key; ?>" <?php echo isset($gender) && $gender == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="col-md-4 mb-10">
                        <label for="add_phone"><?php echo $this->lang->line('phone'); ?> <span class="required">*</span></label>
                        <input type="number" class="form-control" name="phone" id="add_phone" value="<?php echo isset($phone) ?  $phone : ''; ?>" placeholder="<?php echo $this->lang->line('phone'); ?>" required autocomplete="off">
                    </div>
                    <div class="col-md-2 mb-10">
                        <label for="age"><?php echo $this->lang->line('age'); ?></label>
                        <input type="number" min="0" class="form-control" id="age" name="age" value="<?php echo isset($age) ?  $age : ''; ?>" placeholder="<?php echo $this->lang->line('age'); ?>" autocomplete="off">
                    </div>

                    <div class="col-md-2 mb-10">
                        <label for="month"><?php echo $this->lang->line('month'); ?></label>
                        <input type="number" min="1" max="12" class="form-control" id="month" name="month" value="<?php echo isset($month) ?  $month : ''; ?>" placeholder="<?php echo $this->lang->line('month'); ?>" autocomplete="off">
                    </div>

                    <div class="col-md-2 mb-10">
                        <label for="day"><?php echo $this->lang->line('day'); ?></label>
                        <input type="number" min="1" max="31" class="form-control" id="day" name="day" value="<?php echo isset($day) ?  $day : ''; ?>" placeholder="<?php echo $this->lang->line('day'); ?>" autocomplete="off">
                    </div>
                    <div class="col-md-6 mb-10">
                        <label for="add_address"><?php echo $this->lang->line('address'); ?></label>
                        <input type="text" class="form-control" id="add_address" name="address" value="<?php echo isset($address) ?  $address : ''; ?>" placeholder="<?php echo $this->lang->line('address'); ?>">
                    </div>
                    <div class="col-md-6 mb-10">
                        <label for="category_id"><?php echo $this->lang->line('category'); ?> <span class="required">*</span></label>
                        <select class="form-control select2" name="category_id" id="add_category_id" required>
                            <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('category'); ?></option>
                            <?php foreach ($categories as $obj) { ?>
                                <option value="<?php echo $obj->id; ?>"><?php echo $obj->name; ?> [<?php echo $obj->day; ?>]</option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="col-md-6 mb-10">
                        <label for="add_note"><?php echo $this->lang->line('remark'); ?></label>
                        <input type="text" class="form-control" id="add_note" name="note" value="<?php echo isset($note) ?  $note : ''; ?>" placeholder="<?php echo $this->lang->line('remark'); ?>">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <input type="hidden" name="role_id" value="<?php echo PATIENT; ?>">
                <button type="button" class="btn btn-gradient-danger" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                <button type="submit" class="btn btn-gradient-primary"><?php echo $this->lang->line('submit'); ?></button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<script>
    $(document).ready(function(e) {
        $("#addPatientForm").on('submit', (function(e) {
            e.preventDefault();
            $('button[type=submit]').attr('disabled', true);
            if ($("#add_name").val() != "" && $("#add_phone").val() != "" && $("#add_gender").val() != "" && $("#add_category_id").val() != "") {
                $.ajax({
                    url: '<?php echo site_url('followup/patient/add') ?>',
                    type: "POST",
                    data: new FormData(this),
                    dataType: 'json',
                    contentType: false,
                    cache: false,
                    processData: false,
                    success: function(data) {
                        if (data.status == "failed") {
                            var message = "";
                            $.each(data.error, function(index, value) {
                                $("." + index).html(value);
                                message += value;
                            });
                            $.toast({
                                text: message,
                                position: 'top-right',
                                loaderBg: '#7a5449',
                                class: 'jq-toast-danger',
                                hideAfter: 3500,
                                stack: 6,
                                showHideTransition: 'fade'
                            });
                        } else {
                            $.toast({
                                text: data.message,
                                position: 'top-right',
                                loaderBg: '#7a5449',
                                class: 'jq-toast-primary',
                                hideAfter: 3500,
                                stack: 6,
                                showHideTransition: 'fade'
                            });
                            window.location.href = "<?php echo site_url('followup/patient'); ?>";
                        }
                    },
                    error: function() {
                        alert("Fail")
                    }
                });
            } else {
                $.toast({
                    text: "Please select all required field",
                    position: 'top-right',
                    loaderBg: '#7a5449',
                    class: 'jq-toast-danger',
                    hideAfter: 3500,
                    stack: 6,
                    showHideTransition: 'fade'
                });
            }
        }));
    });
</script>