<!--Add Appointment Modal-->
<div class="modal fade editModalCenter" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content modal-media-content">
            <div class="modal-header">
                <h5 class="modal-title mr-30"><?php echo $this->lang->line('edit') . " " . $this->lang->line('patient'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <?php echo form_open_multipart(site_url('followup/patient/edit'), array('name' => 'editPatientForm', 'id' => 'editPatientForm', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
            <div class="modal-body">
                <div class="form-row">
                    <div class="col-md-4 mb-10">
                        <label for="edit_status"><?php echo $this->lang->line('status'); ?> <span class="required">*</span></label>
                        <select class="form-control custom-select" name="status" id="edit_status" required>
                            <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                            <option value="1"><?php echo $this->lang->line('yes'); ?></option>
                            <option value="0"><?php echo $this->lang->line('no'); ?></option>
                        </select>
                    </div>
                    <div class="col-md-8 mb-10">
                        <label for="edit_note"><?php echo $this->lang->line('remark'); ?></label>
                        <input type="text" class="form-control" id="edit_note" name="note" value="<?php echo isset($note) ?  $note : ''; ?>" placeholder="<?php echo $this->lang->line('remark'); ?>">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <input type="hidden" id="edit_id" name="id">
                <button type="button" class="btn btn-gradient-danger" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                <button type="submit" class="btn btn-gradient-primary"><?php echo $this->lang->line('submit'); ?></button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<script>
    function get_edit_modal(id) {
        $('#edit_id').val(id);
    }
    $(document).ready(function(e) {
        $("#editPatientForm").on('submit', (function(e) {
            e.preventDefault();
            $('button[type=submit]').attr('disabled', true);
            if ($("#edit_status").val() != "") {
                $.ajax({
                    url: '<?php echo site_url('followup/patient/edit') ?>',
                    type: "POST",
                    data: new FormData(this),
                    dataType: 'json',
                    contentType: false,
                    cache: false,
                    processData: false,
                    success: function(data) {
                        if (data.status == "failed") {
                            var message = "";
                            $.each(data.error, function(index, value) {
                                $("." + index).html(value);
                                message += value;
                            });
                            $.toast({
                                text: message,
                                position: 'top-right',
                                loaderBg: '#7a5449',
                                class: 'jq-toast-danger',
                                hideAfter: 3500,
                                stack: 6,
                                showHideTransition: 'fade'
                            });
                        } else {
                            $.toast({
                                text: data.message,
                                position: 'top-right',
                                loaderBg: '#7a5449',
                                class: 'jq-toast-primary',
                                hideAfter: 3500,
                                stack: 6,
                                showHideTransition: 'fade'
                            });
                            window.location.href = "<?php echo site_url('followup/patient'); ?>";
                        }
                    },
                    error: function() {
                        alert("Fail")
                    }
                });
            } else {
                $.toast({
                    text: "Please select all required field",
                    position: 'top-right',
                    loaderBg: '#7a5449',
                    class: 'jq-toast-danger',
                    hideAfter: 3500,
                    stack: 6,
                    showHideTransition: 'fade'
                });
            }
        }));
    });
</script>