<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('holiday'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_holiday'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('hrm/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(ADD, 'hrm', 'holiday')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-gift font-30 mr-10"></i>
                            <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('holiday'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'hrm', 'holiday')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('hrm/holiday'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('holiday'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('hrm/holiday/add'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-6 mb-10">
                            <label for="title"><?php echo $this->lang->line('holiday'); ?> <?php echo $this->lang->line('title'); ?></label>
                            <input type="text" class="form-control" name="title" id="title" value="<?php echo isset($title) ?  $title : ''; ?>" placeholder="<?php echo $this->lang->line('holiday'); ?> <?php echo $this->lang->line('title'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="title" class="form-text text-muted">
                                <?php echo form_error('title'); ?>
                            </small>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="bn_title"><?php echo $this->lang->line('holiday'); ?> <?php echo $this->lang->line('bn_title'); ?></label>
                            <input type="text" class="form-control" name="bn_title" id="bn_title" value="<?php echo isset($bn_title) ?  $bn_title : ''; ?>" placeholder="<?php echo $this->lang->line('holiday'); ?> <?php echo $this->lang->line('bn_title'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="from_date"><?php echo $this->lang->line('from_date'); ?></label>
                            <input type="text" class="form-control date" name="from_date" id="from_date" value="<?php echo isset($from_date) ?  $from_date : ''; ?>" placeholder="<?php echo $this->lang->line('from_date'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="from_date" class="form-text text-muted">
                                <?php echo form_error('from_date'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="to_date"><?php echo $this->lang->line('to_date'); ?></label>
                            <input type="text" class="form-control date" name="to_date" id="to_date" value="<?php echo isset($to_date) ?  $to_date : ''; ?>" placeholder="<?php echo $this->lang->line('to_date'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="to_date" class="form-text text-muted">
                                <?php echo form_error('to_date'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mt-40">
                            <div class="custom-control custom-checkbox checkbox-primary">
                                <input type="checkbox" class="custom-control-input" name="is_view_on_web" id="is_view_on_web" value="1">
                                <label class="custom-control-label" for="is_view_on_web"><?php echo $this->lang->line('is_view_on_web'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-3 mt-40">
                            <div class="custom-control custom-checkbox checkbox-cyan">
                                <input type="checkbox" class="custom-control-input" name="status" id="status" value="1" checked>
                                <label class="custom-control-label" for="status"><?php echo $this->lang->line('status'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('remark'); ?></span>
                                </div>
                                <textarea class="form-control" name="remark" id="remark" aria-label="<?php echo $this->lang->line('remark'); ?>"><?php echo isset($remark) ?  $remark : ''; ?></textarea>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('hrm/holiday'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<script>
    $(".date").daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY-MM-DD'
        }
    });
</script>