<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Patient_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_patient_list($keyword, $gender, $religion) {
        $this->db->select('P.*');
        $this->db->from('patients AS P');
        $this->db->join('users AS U', 'U.id = P.user_id', 'left');
        if ($keyword) {
            $this->db->group_start();
            $this->db->like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
            $this->db->or_like('P.address', $keyword, 'both');
            $this->db->or_like('P.guardian_address', $keyword, 'both');
            $this->db->group_end();
        }
        if ($gender) {
            $this->db->where('P.gender', $gender);
        }
        if ($religion) {
            $this->db->where('P.religion', $religion);
        }
        $this->db->where('U.role_id', PATIENT);
        $this->db->where('P.status', 1);
        $this->db->order_by('P.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_sms_list($limit, $offset, $search, $count) {
        $this->db->select('TM.*, R.name as role, E.name as created_by');
        $this->db->from('text_messages AS TM');
        $this->db->join('roles AS R', 'R.id = TM.role_id', 'left');
        $this->db->join('employees AS E', 'E.user_id = TM.created_by', 'left');
        if ($search) {
            $this->db->like('TM.body', $search, 'both');
            $this->db->or_like('R.name', $search, 'both');
            $this->db->or_like('E.name', $search, 'both');
        }
        $this->db->where('TM.sms_type', 'patient');
        $this->db->order_by('TM.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }
}
