<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('refund'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_invoice'); ?>
        </h4>

        <div class="align-items-center">
            <?php if (has_permission(VIEW, 'pharmacy', 'refund')) { ?>
                <button class="btn btn-xs btn-outline-light btn-wth-icon icon-wthot-bg" onclick="printBill(<?php echo $this->uri->segment(4, 0); ?>);">
                    <span class="icon-label"><i class="fa fa-print"></i> </span>
                    <span class="btn-text"><?php echo $this->lang->line('print'); ?> </span>
                </button>
            <?php } ?>
            <?php if (has_permission(VIEW, 'pharmacy', 'purchase')) { ?>
                <a href="<?php echo site_url('pharmacy/purchase'); ?>" class="btn btn-xs btn-info">
                    <i class="fa fa-cart-plus font-12 mr-5"></i>
                    <?php echo $this->lang->line('purchase'); ?>
                </a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'pharmacy', 'stock')) { ?>
                <a href="<?php echo site_url('pharmacy/stock'); ?>" class="btn btn-xs btn-success">
                    <i class="fa fa-bar-chart font-12 mr-5"></i>
                    <?php echo $this->lang->line('stock'); ?>
                </a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'pharmacy', 'sale')) { ?>
                <a href="<?php echo site_url('pharmacy/sale'); ?>" class="btn btn-xs btn-danger">
                    <i class="fa fa-balance-scale font-12 mr-5"></i>
                    <?php echo $this->lang->line('sale'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(VIEW, 'pharmacy', 'refund')) { ?>
                <a href="<?php echo site_url('pharmacy/refund'); ?>" class="btn btn-xs btn-blue">
                    <i class="fa fa-undo font-12 mr-5"></i>
                    <?php echo $this->lang->line('manage_refund'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(VIEW, 'pharmacy', 'refund')) { ?>
                <a href="<?php echo site_url('pharmacy/refund/customer'); ?>" class="btn btn-xs btn-pink">
                    <i class="fa fa-list font-12 mr-5"></i>
                    <?php echo $this->lang->line('refund'); ?> <?php echo $this->lang->line('list'); ?>
                </a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->


    <!-- Row -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper hk-invoice-wrap pa-35">
                <div class="invoice-to-wrap pb-0">
                    <div class="row">
                        <div class="col-md-8 mb-30">
                            <span class="d-block text-uppercase mb-5 font-13">billing to</span>
                            <h6 class="mb-5 text-uppercase">
                                <?php
                                if ($customer->walking == 1) {
                                    echo $this->lang->line('walking') . ' ' . $this->lang->line('customer');
                                } elseif ($customer->customer_id > 0) {
                                    echo $customer->customer;
                                    echo $customer->patient_unique_id ? ' [' . $customer->patient_unique_id . ']' : '';
                                } else {
                                    echo $customer->customer_name;
                                }
                                ?>
                            </h6>
                            <address>
                                <span class="d-block">Sex & Age : <?php echo isset($customer->gender) ? $this->lang->line($customer->gender) : ''; ?> / <?php echo isset($customer->dob) ? floor((time() - strtotime($customer->dob)) / 31556926) . 'Y' : ''; ?></span>
                                <span class="d-block">Address : <?php echo isset($customer->address) ? $customer->address : ''; ?></span>
                                <span class="d-block">Phone : <?php echo isset($customer->phone) ? $customer->phone : ''; ?></span>
                                <span class="d-block">Email : <?php echo isset($customer->email) ? $customer->email : ''; ?></span>
                            </address>
                        </div>
                        <div class="col-md-4 mb-30">
                            <span class="d-block text-uppercase mb-5 font-13">billing from</span>
                            <h6 class="mb-5 text-uppercase"><?php echo $this->global_setting->brand_title; ?></h6>
                            <address>
                                <span class="d-block"><?php echo $this->global_setting->address; ?></span>
                                <span class="d-block">Phone: <?php echo $this->global_setting->phone; ?></span>
                                <span class="d-block">Email: <?php echo $this->global_setting->email; ?></span>
                                <span class="d-block text-red font-weight-bold">Invoice#: <?php echo $invoice->custom_invoice_id; ?></span>
                                <?php if ($invoice->prev_invoice_id > 0  && $invoice->prev_invoice_id != null) { ?>
                                    <span class="d-block text-mute font-11">
                                        Prev Invoice#:
                                        <?php
                                        $prev =  $this->refund->get_single('medicine_refunds', array('id' => $invoice->prev_invoice_id));
                                        echo isset($prev->custom_invoice_id) ? $prev->custom_invoice_id : '';
                                        ?>
                                    </span>
                                <?php } ?>
                                <span class="d-block">Bill Date: <?php echo date('d/m/Y, h:ia', strtotime($invoice->bill_date)); ?></span>
                                <?php if ($invoice->paid_status == 'unpaid' && $invoice->due_amount > 0) { ?>
                                    <span class="d-block text-uppercase text-red font-weight-bold">Due: <?php echo $invoice->due_amount; ?></span>
                                <?php } ?>
                            </address>
                        </div>
                    </div>
                </div>
                <?php if (isset($details) & !empty($details)) { ?>
                    <div class="invoice-details">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm table-border mb-0">
                                    <thead class="text-center bg-gradient-sunset">
                                        <tr>
                                            <th class="text-white font-weight-700 text-center w-15">SL. No</th>
                                            <th class="text-white font-weight-700 text-left w-30">Medicine Name</th>
                                            <th class="text-white font-weight-700 text-center w-10">Batch No</th>
                                            <th class="text-white font-weight-700 text-center w-15">Expiry Date</th>
                                            <th class="text-white font-weight-700 text-center w-10">Quantity</th>
                                            <th class="text-white font-weight-700 text-center w-10">Rate</th>
                                            <th class="text-white font-weight-700 text-center w-10">Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1; ?>
                                        <?php foreach ($details as $obj) { ?>
                                            <tr>
                                                <td class="text-center"><?php echo $count++; ?></td>
                                                <td class="text-left"><?php echo $obj->medicine_name; ?></td>
                                                <td class="text-right"><?php echo $obj->batch_no; ?></td>
                                                <td class="text-right"></td>
                                                <td class="text-center"><?php echo $obj->quantity; ?></td>
                                                <td class="text-right"><?php echo $obj->rate; ?></td>
                                                <td class="text-right"><?php echo $obj->total_rate; ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot class="border-bottom border-1">
                                        <tr>
                                            <th colspan="6" class="text-right font-weight-600">Total Refund</th>
                                            <th class="text-right font-weight-600 text-red"><?php echo $invoice->total_refund; ?></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </section>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<script>
    function printBill(id) {
        $.ajax({
            url: '<?php echo site_url('pharmacy/refund/customer_invoice_print'); ?>',
            type: 'POST',
            data: {
                id: id,
            },
            success: function(result) {
                $("#testdata").html(result);
                popup(result);
            }
        });
    }

    function popup(data) {
        var frame1 = $('<iframe />');
        frame1[0].name = "frame1";
        frame1.css({
            "position": "absolute",
            "top": "-1000000px"
        });
        $("body").append(frame1);
        var frameDoc = frame1[0].contentWindow ? frame1[0].contentWindow : frame1[0].contentDocument.document ? frame1[0].contentDocument.document : frame1[0].contentDocument;
        frameDoc.document.open();
        //Create a new HTML document.
        frameDoc.document.write('<html>');
        frameDoc.document.write('<head>');
        frameDoc.document.write('<title>Print Invoice</title>');

        frameDoc.document.write('</head>');
        frameDoc.document.write('<body>');
        frameDoc.document.write(data);
        frameDoc.document.write('</body>');
        frameDoc.document.write('</html>');
        frameDoc.document.close();
        setTimeout(function() {
            window.frames["frame1"].focus();
            window.frames["frame1"].print();
            frame1.remove();
        }, 500);

        return true;

    }
</script>