<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'radiology', 'report')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-flask font-30 mr-10"></i>
                            <?php echo $this->lang->line('report'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>

                    <?php echo form_open_multipart(site_url('radiology/report/create'), array('name' => 'search', 'id' => 'search', 'class' => 'form-inline needs-validation', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                    <div class="form-group">
                        <div class="form-group mr-10">
                            <div class="input-group">
                                <div class="input-group-append">
                                    <button class="btn btn-gradient-primary" type="button"><?php echo $this->lang->line('keyword'); ?></button>
                                </div>
                                <input type="text" class="form-control" name="keyword" id="keyword" value="<?php echo isset($keyword) ?  $keyword : ''; ?>" placeholder="<?php echo $this->lang->line('keyword'); ?>">
                            </div>
                        </div>
                        <div class="form-group mr-10">
                            <div class="input-group">
                                <div class="input-group-append">
                                    <button class="btn btn-gradient-primary" type="button"><?php echo $this->lang->line('date'); ?></button>
                                </div>
                                <input type="text" class="form-control" name="date" id="reportrange" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>">
                            </div>
                        </div>
                        <div class="form-group mr-10">
                            <select class="form-control custom-select select2" name="doctor_id" id="doctor_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('doctor'); ?></option>
                                <?php foreach ($doctors as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($doctor_id) && $doctor_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <button class="btn btn-primary float-right" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>

                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('invoice_no'); ?></th>
                                        <th><?php echo $this->lang->line('date'); ?></th>
                                        <th><?php echo $this->lang->line('patient_id'); ?></th>
                                        <th><?php echo $this->lang->line('name'); ?></th>
                                        <th><?php echo $this->lang->line('phone'); ?></th>
                                        <th><?php echo $this->lang->line('delivery'); ?></th>
                                        <th><?php echo $this->lang->line('ref_by'); ?></th>
                                        <th width="10%"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($invoices) && !empty($invoices)) { ?>
                                        <?php foreach ($invoices as $obj) {
                                            $template = $this->report->get_complete_template_status($obj->patient_id, $obj->id, $obj->investagation_id);
                                            if (!$template) {
                                        ?>
                                                <tr>
                                                    <td><?php echo $sl_count; ?></td>
                                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                                    <td><?php echo date('Y-m-d h:i A', strtotime($obj->bill_date)); ?></td>
                                                    <td><?php echo $obj->patient_unique_id; ?></td>
                                                    <td>
                                                        <?php if (has_permission(VIEW, 'radiology', 'report')) { ?>
                                                            <a href="<?php echo site_url('radiology/report/generate/' . $obj->id); ?>"><?php echo $obj->patient_name; ?></a>
                                                        <?php } else { ?>
                                                            <?php echo $obj->patient_name; ?>
                                                        <?php } ?>
                                                    </td>
                                                    <td><?php echo $obj->phone; ?></td>
                                                    <td><?php echo $obj->delivery_status == 'normal' ? '<span class="badge badge-success">' . $this->lang->line('normal') . '</span>' : '<span class="badge badge-danger">' . $this->lang->line('urgent') . '</span>'; ?></td>
                                                    <td>
                                                        <?php if ($obj->self) {
                                                            echo 'Self';
                                                        } elseif ($obj->ref_dr_id > 0) {
                                                            echo $obj->ref_by;
                                                        } else {
                                                            echo $obj->ref_dr_name;
                                                        } ?>
                                                    </td>
                                                    <td>
                                                        <?php if (has_permission(VIEW, 'radiology', 'report')) { ?>
                                                            <a href="<?php echo site_url('radiology/report/generate/' . $obj->id); ?>" class="btn btn-info btn-xs mr-25"> <i class="fa fa-eye"></i> </a>
                                                        <?php } ?>
                                                    </td>
                                                </tr>
                                        <?php $sl_count++;
                                            }
                                        } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="9"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
        width: 180px;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#reportrange').daterangepicker({
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    });
</script>