<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Marketing.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Marketing
 * @description     : Manage marketing report.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Marketing extends MY_Controller
{

    public $data = array();

    function __construct()
    {
        parent::__construct();
        $this->load->model('Marketing_Model', 'marketing', true);

        $this->data['doctors'] = $this->marketing->get_doctor_list();
        $this->data['references'] = $this->marketing->get_list('employees', array('status' => 1));
        $this->data['employees'] = $this->marketing->get_employee_list();
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Marketing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index()
    {

        check_permission(VIEW);

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('marketing') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/marketing/index', $this->data);
    }

    /*****************Function income**********************************
     * @type            : Function
     * @function name   : income
     * @description     : Load "Income Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function income()
    {

        check_permission(VIEW);

        if ($_GET) {
            $type = $this->input->get('type');
            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $commission = $this->input->get('commission');
            $created_by = $this->input->get('created_by');

            $this->data['marketings'] = $this->marketing->get_marketing_list($type, $keyword, $form_date, $to_date, $doctor_id, $reference_id, $commission, $created_by);
            $this->data['type'] = $type;
            $this->data['keyword'] = $keyword;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['commission'] = $commission;
            $this->data['created_by'] = $created_by;
        }

        $this->data['doctors'] = $this->marketing->get_doctor_list();
        $this->data['references'] = $this->marketing->get_list('employees', array('status' => 1));
        $this->data['employees'] = $this->marketing->get_employee_list();
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('marketing') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('marketing/income/index', $this->data);
    }

    public function income_pdf()
    {
        if ($_GET) {
            $type = $this->input->get('type');
            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $commission = $this->input->get('commission');
            $created_by = $this->input->get('created_by');

            $this->data['marketings'] = $this->marketing->get_marketing_list($type, $keyword, $form_date, $to_date, $doctor_id, $reference_id, $commission, $created_by);
            $this->data['type'] = $type;
            $this->data['keyword'] = $keyword;
            $this->data['form_date'] = $form_date;
            $this->data['commission'] = $commission;
            $this->data['doctor'] = $this->marketing->get_single_doctor($doctor_id);
            $this->data['employee'] = $this->marketing->get_single_employee($created_by);

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('marketing/income/pdf', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('marketing_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function investigation**********************************
     * @type            : Function
     * @function name   : investigation
     * @description     : Load "investigation Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function investigation()
    {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            if ($this->session->userdata('role_id') == MARKETING) {
                $created_by = $this->session->userdata('user_id');
            } else {
                $created_by = $this->input->get('created_by');
            }

            $this->data['investigations'] = $this->marketing->get_patient_investigation_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('investigation') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('marketing/investigation/index', $this->data);
    }

    /*****************Function investigation_pdf**********************************
     * @type            : Function
     * @function name   : investigation_pdf
     * @description     : Load "Generate PDF Investigation Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function investigation_pdf()
    {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            if ($this->session->userdata('role_id') == MARKETING) {
                $created_by = $this->session->userdata('user_id');
            } else {
                $created_by = $this->input->get('created_by');
            }
            $this->data['investigations'] = $this->marketing->get_patient_investigation_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;

            $this->data['createdby'] = $this->marketing->get_single('employees', array('user_id' => $created_by, 'status' => 1));
            $this->data['reference'] = $this->marketing->get_single('employees', array('user_id' => $reference_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('marketing/investigation/pdf', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('investigation_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function investigation**********************************
     * @type            : Function
     * @function name   : investigation
     * @description     : Load "investigation Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function vd()
    {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            if ($this->session->userdata('role_id') == MARKETING) {
                $created_by = $this->session->userdata('user_id');
            } else {
                $created_by = $this->input->get('created_by');
            }

            $this->data['investigations'] = $this->marketing->get_vd_investigation_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('investigation') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('marketing/vd/index', $this->data);
    }

    
    /*****************Function investigation_pdf**********************************
     * @type            : Function
     * @function name   : investigation_pdf
     * @description     : Load "Generate PDF Investigation Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function vd_pdf()
    {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            if ($this->session->userdata('role_id') == MARKETING) {
                $created_by = $this->session->userdata('user_id');
            } else {
                $created_by = $this->input->get('created_by');
            }
            $this->data['investigations'] = $this->marketing->get_vd_investigation_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;

            $this->data['createdby'] = $this->marketing->get_single('employees', array('user_id' => $created_by, 'status' => 1));
            $this->data['reference'] = $this->marketing->get_single('employees', array('user_id' => $reference_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('marketing/vd/pdf', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('investigation_' . rand() . '.pdf', 'D');
        }
    }

}
