<!DOCTYPE html>
<html>

<head>
    <title>Yearly</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            width: 100%;
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .total {
            margin-top: 20px;
        }

        .total_table tbody td {
            padding: 2px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }
        .text-center{
            text-align: center;
        }
        .text-uppercase{
            text-transform: uppercase;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->
            <h2 align="center">
                YEARLY ATTENDANCE REPORT<br>
                <span>Year: <?php echo $year; ?></span>
            </h2>
            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%" align="left">
                                <?php if (isset($user_id) && !empty($user_id)) { ?>
                                    <b>Employee:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        <?php echo $employee->name; ?>, <?php echo $employee->phone; ?>
                                    </span>
                                <?php } else { ?>
                                    <b>Employee:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        All
                                    </span>
                                <?php } ?>
                            </td>
                            <td width="30%" align="right">
                                <b>Print Date:</b>
                                <span style="font-size: 12px;"><?php echo date('M d, Y h:ia'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <tr>
                            <th class="text-white">
                                Month <i class="fa fa-long-arrow-down"></i>
                                Date <i class="fa fa-long-arrow-right"></i>
                            </th>
                            <?php for ($i = 1; $i <= $days; $i++) {
                                $i = str_pad($i, 2, 0, STR_PAD_LEFT);
                            ?>
                                <th class="text-white text-center">
                                    <strong><?php echo $i; ?></strong>
                                </th>
                            <?php } ?>
                            <th class="text-white text-center">
                                <strong>Total</strong>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $months = get_months();
                        foreach ($months as $key => $value) {
                            $month = date('m', strtotime($key));
                        ?>
                            <tr>
                                <td><?php echo $value; ?></td>
                                <?php for ($i = 1; $i <= $days; $i++) {
                                    $i = str_pad($i, 2, 0, STR_PAD_LEFT);
                                    $attendance_date = $year . '-' . $month . '-' . $i;
                                    // Attendance fetch
                                    $attendance = $this->attendance->get_monthly_attendance_list($attendance_date, null, $user_id);
                                ?>
                                    <?php if (isset($attendance) && !empty($attendance)) { ?>
                                        <?php foreach ($attendance as $row) { ?>
                                            <td class="text-uppercase text-center"><?php echo $row->attendance_status; ?></td>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <td class="text-uppercase text-center">--</td>
                                    <?php } ?>
                                <?php } ?>
                                <td class="text-center">
                                    <?php
                                    $total_present = $this->attendance->get_total_present_count($user_id, $year, $month);
                                    echo $total_present ? $total_present : '';
                                    ?>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <!-- Content End -->
            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Prepared By:</b>
                                    <?php echo $this->session->userdata('name'); ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>