<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('summary'); ?> <?php echo $this->lang->line('attendance'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="d-flex">
            <?php echo $this->load->view('header'); ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('report/attendance/summary'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="date" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>">
                        </div>
                        <div class="col-md-9 mb-10">
                            <label for="department"><?php echo $this->lang->line('department'); ?></label>
                            <br>
                            <?php foreach ($departments as $obj) { ?>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="checkbox" id="department_<?php echo $obj->id; ?>" name="department_id[]" value="<?php echo $obj->id; ?>">
                                    <label class="form-check-label" for="department_<?php echo $obj->id; ?>"><?php echo $obj->name; ?></label>
                                </div>
                            <?php } ?>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>

        <?php if (isset($attendances) && !empty($attendances)) { ?>
            <!-- Report Details -->
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <?php if (has_permission(VIEW, 'report', 'attendance')) { ?>
                            <h6 class="card-header d-flex align-items-center">
                                <i class="fa fa-clock-o font-30 mr-10"></i>
                                <?php echo $this->lang->line('summary'); ?> <?php echo $this->lang->line('attendance'); ?> <?php echo $this->lang->line('report'); ?>
                            </h6>
                        <?php } ?>
                        <?php if (has_permission(ADD, 'report', 'attendance')) { ?>
                            <div class="button-list">
                                <a href="<?php echo site_url('report/attendance/summary_pdf?date=' . $date); ?>" class="btn btn-success btn-xs">
                                    <i class="fa fa-download"></i> <?php echo $this->lang->line('pdf'); ?> <?php echo $this->lang->line('generate'); ?>
                                </a>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm mb-0">
                                    <thead class="bg-gradient-success text-white">
                                        <tr>
                                            <th class="text-white"><?php echo $this->lang->line('sl_no'); ?></th>
                                            <th class="text-white"><?php echo $this->lang->line('department'); ?></th>
                                            <th class="text-white"><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('employee'); ?></th>
                                            <th class="text-white"><?php echo $this->lang->line('male'); ?></th>
                                            <th class="text-white"><?php echo $this->lang->line('female'); ?></th>
                                            <th class="text-white"><?php echo $this->lang->line('present'); ?></th>
                                            <th class="text-white"><?php echo $this->lang->line('absent'); ?></th>
                                            <th class="text-white"><?php echo $this->lang->line('leave'); ?></th>
                                            <th class="text-white"><?php echo $this->lang->line('weekend'); ?></th>
                                            <th class="text-white"><?php echo $this->lang->line('late'); ?></th>
                                            <th class="text-white"><?php echo $this->lang->line('early_leaving'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1;
                                        $total_employee = 0;
                                        $total_male = 0;
                                        $total_female = 0;
                                        $total_present = 0;
                                        $total_absent = 0;
                                        $total_leave = 0;
                                        $total_weekend = 0;
                                        $total_late = 0;
                                        $total_early_leaving = 0;
                                        if (isset($attendances) && !empty($attendances)) { ?>
                                            <?php foreach ($attendances as $obj) { ?>
                                                <tr>
                                                    <td><?php echo $count++; ?></td>
                                                    <td><?php echo $obj->name; ?></td>
                                                    <td>
                                                        <?php
                                                        $employee = $this->attendance->count_all('employees', array('employee_type' => 'staff', 'department_id' => $obj->id, 'status' => 1));
                                                        echo $employee;
                                                        $total_employee += $employee;
                                                        ?>
                                                    </td>
                                                    <td>
                                                        <?php
                                                        $male = $this->attendance->count_all('employees', array('gender' => 'male', 'employee_type' => 'staff', 'department_id' => $obj->id, 'status' => 1));
                                                        echo $male;
                                                        $total_male += $male;
                                                        ?>
                                                    </td>
                                                    <td>
                                                        <?php
                                                        $female = $this->attendance->count_all('employees', array('gender' => 'female', 'employee_type' => 'staff', 'department_id' => $obj->id, 'status' => 1));
                                                        echo $female;
                                                        $total_female += $female;
                                                        ?>
                                                    </td>
                                                    <td>
                                                        <?php
                                                        $present = $this->attendance->get_summary_count_attendance($obj->id, $date, 'p', null);
                                                        echo $present;
                                                        $total_present += $present;
                                                        ?>
                                                    </td>
                                                    <td>
                                                        <?php
                                                        $absent = $this->attendance->get_summary_count_attendance($obj->id, $date, 'a', null);
                                                        echo $absent;
                                                        $total_absent += $absent;
                                                        ?>
                                                    </td>
                                                    <td>
                                                        <?php
                                                        $leave = $this->attendance->get_summary_count_attendance($obj->id, $date, 'l', null);
                                                        echo $leave;
                                                        $total_leave += $leave;
                                                        ?>
                                                    </td>
                                                    <td>
                                                        <?php
                                                        $weekend = $this->attendance->get_summary_count_attendance($obj->id, $date, 'w', null);
                                                        echo $weekend;
                                                        $total_weekend += $weekend;
                                                        ?>
                                                    </td>
                                                    <td>
                                                        <?php
                                                        $late = $this->attendance->get_summary_count_attendance($obj->id, $date, null, 'late');
                                                        echo $late;
                                                        $total_late += $late;
                                                        ?>
                                                    </td>
                                                    <td>
                                                        <?php
                                                        $early_leaving = $this->attendance->get_summary_count_attendance($obj->id, $date, null, 'early_leaving');
                                                        echo $early_leaving;
                                                        $total_early_leaving += $early_leaving;
                                                        ?>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot class="bg-gradient-primary">
                                        <tr>
                                            <th colspan="2" class="text-right font-weight-600 text-white"><?php echo $this->lang->line('total'); ?></th>
                                            <th class="font-weight-600 text-white"><?php echo $total_employee; ?></th>
                                            <th class="font-weight-600 text-white"><?php echo $total_male; ?></th>
                                            <th class="font-weight-600 text-white"><?php echo $total_female; ?></th>
                                            <th class="font-weight-600 text-white"><?php echo $total_present; ?></th>
                                            <th class="font-weight-600 text-white"><?php echo $total_absent; ?></th>
                                            <th class="font-weight-600 text-white"><?php echo $total_leave; ?></th>
                                            <th class="font-weight-600 text-white"><?php echo $total_weekend; ?></th>
                                            <th class="font-weight-600 text-white"><?php echo $total_late; ?></th>
                                            <th class="font-weight-600 text-white"><?php echo $total_early_leaving; ?></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<script>
    $('#date').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        }
    });
</script>