<!DOCTYPE html>
<html>

<head>
    <title>Test</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            width: 100%;
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .total {
            margin-top: 20px;
        }

        .total_table tbody td {
            padding: 2px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->
            <h2 align="center">TEST SUMMARY REPORT</h2>
            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="80%" align="left">
                                <?php if (isset($doctor_id) && !empty($doctor_id)) { ?>
                                    <b>Doctor:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        <?php echo $doctor->name; ?>, <?php echo $doctor->specialist; ?>
                                    </span>
                                <?php } else { ?>
                                    <b>Doctor:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        All
                                    </span>
                                <?php } ?>
                            </td>
                            <td width="20%" align="right">
                                <b>Date:</b>
                                <span style="font-size: 12px;"><?php echo date('d/m/Y h:i A'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <tr>
                            <th style="width: 5%;">Sl. No</th>
                            <th style="width: 15%;">Department</th>
                            <th style="width: 10%;">Group</th>
                            <th style="width: 25%;">Test Name</th>
                            <th style="width: 9%;">Rate</th>
                            <th style="width: 12%;">Total Test</th>
                            <th style="width: 12%;">Total Amount</th>
                            <th style="width: 12%;">Total Discount</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $count = 1;
                        $total_rate = 0;
                        $total_test_amount = 0;
                        $total_amount = 0;
                        $total_discount = 0;
                        if (isset($tests) && !empty($tests)) { ?>
                            <?php foreach ($tests as $obj) {
                                $test = $this->billing->count_all_invoice_details($obj->id, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
                                $total_rate += $obj->rate;
                                $total_test_amount += $test->total_test;
                                $total_amount += $test->total;
                                $total_discount += $test->discount;
                            ?>
                                <tr>
                                    <td><?php echo $count++; ?></td>
                                    <td><?php echo $obj->department; ?></td>
                                    <td><?php echo $obj->group; ?></td>
                                    <td><?php echo $obj->name; ?></td>
                                    <td><?php echo $obj->rate; ?></td>
                                    <td><?php echo $test->total_test; ?></td>
                                    <td><?php echo $test->total; ?></td>
                                    <td><?php echo $test->discount; ?></td>
                                </tr>
                            <?php } ?>
                        <?php } ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th colspan="4" align="right">Total</th>
                            <th><?php echo number_format($total_rate, 2); ?></th>
                            <th><?php echo number_format($total_test_amount, 2); ?></th>
                            <th><?php echo number_format($total_amount, 2); ?></th>
                            <th><?php echo number_format($total_discount, 2); ?></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <!-- Content End -->

            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Prepared By:</b>
                                    <?php if (isset($created_by) && !empty($created_by)) {
                                        echo $createdby->name;
                                    } else {
                                        echo $this->session->userdata('name');
                                    } ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>