<!DOCTYPE html>
<html>

<head>
    <title>visitor</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            width: 100%;
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tfoot th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .total {
            margin-top: 20px;
        }

        .total_table tbody td {
            padding: 2px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }

        .mt-3 {
            margin-top: 20px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->
            <h2 align="center">
                VISITOR REPORT
                <small>
                    <?php echo date('M d, Y', strtotime($form_date)); ?> -
                    <?php echo date('M d, Y', strtotime($to_date)); ?>
                </small>
            </h2>
            <h2 align="center">
                HOSPITAL SUMMERY REPORT<br>
                <small>
                    <?php echo date('M d, Y', strtotime($form_date)); ?> -
                    <?php echo date('M d, Y', strtotime($to_date)); ?>
                </small>
            </h2>
            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="80%" align="left">
                                <b>Report:</b>
                                <span style="font-size: 12px; margin: 0; padding: 0;">
                                    All
                                </span>
                            </td>
                            <td width="20%" align="right">
                                <b>Date:</b>
                                <span style="font-size: 12px;"><?php echo date('M d, Y h:ia'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <tr>
                            <th>SL No</th>
                            <th>Emp. Name</th>
                            <th>Total Visit</th>
                            <th>Family Patient</th>
                            <th>Emergency</th>
                            <th>Health Card</th>
                            <th>Health Package</th>
                            <th>Medicine</th>
                            <th>Land</th>
                            <th>Lab Test</th>
                            <th>Surgery</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $count = 1;
                        $total_visit = 0;
                        $total_family_patient = 0;
                        $total_emergency = 0;
                        $total_health_card = 0;
                        $total_health_package = 0;
                        $total_medicine = 0;
                        $total_land = 0;
                        $total_test = 0;
                        $total_surgery = 0;
                        if (isset($visitors) && !empty($visitors)) { ?>
                            <?php foreach ($visitors as $obj) {
                                $total_visit += $obj->total_visit;
                                $total_family_patient += $obj->total_family_patient;
                                $total_emergency += $obj->total_emergency;
                                $total_health_card += $obj->total_health_card;
                                $total_health_package += $obj->total_health_package;
                                $total_medicine += $obj->total_medicine;
                                $total_land += $obj->total_land;
                                $total_test += $obj->total_test;
                                $total_surgery += $obj->total_surgery;
                            ?>
                                <tr>
                                    <td><?php echo $count++; ?></td>
                                    <td><?php echo $obj->created_by; ?></td>
                                    <td><?php echo $obj->total_visit; ?></td>
                                    <td><?php echo $obj->total_family_patient; ?></td>
                                    <td><?php echo $obj->total_emergency; ?></td>
                                    <td><?php echo $obj->total_health_card; ?></td>
                                    <td><?php echo $obj->total_health_package; ?></td>
                                    <td><?php echo $obj->total_medicine; ?></td>
                                    <td><?php echo $obj->total_land; ?></td>
                                    <td><?php echo $obj->total_test; ?></td>
                                    <td><?php echo $obj->total_surgery; ?></td>
                                </tr>
                            <?php } ?>
                        <?php } ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="2"></td>
                            <td><?php echo $total_visit; ?></td>
                            <td><?php echo $total_family_patient; ?></td>
                            <td><?php echo $total_emergency; ?></td>
                            <td><?php echo $total_health_card; ?></td>
                            <td><?php echo $total_health_package; ?></td>
                            <td><?php echo $total_medicine; ?></td>
                            <td><?php echo $total_land; ?></td>
                            <td><?php echo $total_test; ?></td>
                            <td><?php echo $total_surgery; ?></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <!-- Content End -->

            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Printed By:</b>
                                    <?php echo $this->session->userdata('name'); ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>