<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Module.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Module
 * @description     : Manage application module.  
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.rabiulbd.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Module extends MY_Controller {

    public $data = array();
    function __construct() {
        parent::__construct();
        $this->load->model('Setting_Model', 'setting', true);
    }

    public function index() {

        $search = $this->input->get('search');
        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);
        if ($search) {
            $config['base_url'] = site_url('setting/module/?search=') . $search;
        } else {
            $config['base_url'] = current_url();
        }
        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        $config['total_rows'] = $this->setting->get_module_list($config['per_page'], $offset, $search, $count = TRUE);
        $this->pagination->initialize($config);
        $this->data['modules'] = $this->setting->get_module_list($config['per_page'], $offset, $search, $count = FALSE);

        $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        $this->data['search'] = $search;

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('module') . ' ' . $this->lang->line('list') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('module/index', $this->data);
    }

    public function add() {
        if ($_POST) {
            $this->_prepare_module_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_module_data();
                $insert_id = $this->setting->insert('modules', $data);
                if ($insert_id) {
                    create_log('Has been created a module : ' . $data['module_name']);
                    success($this->lang->line('insert_success'));
                    redirect('setting/module');
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('setting/module/add');
                }
            } else {
                $this->data = $_POST;
            }
        }

        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('add') . ' ' . $this->lang->line('module') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('module/add', $this->data);
    }

    public function edit($id = null) {

        if ($_POST) {
            $this->_prepare_module_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_module_data();
                $updated = $this->setting->update('modules', $data, array('id' => $this->input->post('id')));
                if ($updated) {
                    create_log('Has been updated a module : ' . $data['module_name']);
                    success($this->lang->line('update_success'));
                    redirect('setting/module');
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('setting/module/edit/' . $this->input->post('id'));
                }
            } else {
                $this->data = $_POST;
            }
        } else {
            if ($id) {
                $this->data['module'] = $this->setting->get_single('modules', array('id' => $id));
                if (!$this->data['module']) {
                    redirect('setting/module');
                }
            }
        }

        $this->data['edit'] = TRUE;
        $this->layout->title($this->lang->line('edit') . ' ' . $this->lang->line('module') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('module/edit', $this->data);
    }

    private function _prepare_module_validation() {
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
        $this->form_validation->set_rules('module_name', 'module_name', 'trim|required');
        $this->form_validation->set_rules('module_slug', 'module_slug', 'trim|required');
    }

    private function _get_posted_module_data() {

        $items = array();
        $items[] = 'module_name';
        $items[] = 'module_slug';
        $items[] = 'status';
        $data = elements($items, $_POST);

        if ($this->input->post('id')) {
            $data['modified_at'] = date('Y-m-d H:i:s');
            $data['modified_by'] = logged_in_user_id();
        } else {
            $data['created_at'] = date('Y-m-d H:i:s');
            $data['created_by'] = logged_in_user_id();
        }

        return $data;
    }

    public function delete($id = null) {
        $module = $this->setting->get_single('modules', array('id' => $id));
        if ($this->setting->delete('modules', array('id' => $id))) {
            // delete operations data
            $this->setting->delete('operations', array('module_id' => $module->id));
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect('setting/module');
    }
}
