<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************User.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : User
 * @description     : Manage all type of systm users like employee, admin and superadmin.  
 * @author          : South Bangla IT Zone Team 	
 * @url             : http://hms.rabiulbd.com    
 * @support         : rabibd.it@gmail.com	
 * @copyright       : South Bangla IT Zone Team 	
 * ********************************************************** */

class User extends MY_Controller {

    public $data = array();

    public function __construct() {
        parent::__construct();
        $this->load->model('Setting_Model', 'setting', true);
    }


    /*     * ***************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load user filtering interface                 
     *                      
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function index() {

        check_permission(VIEW);

        $role_id = $this->input->get('role_id');
        $user_id = $this->input->get('user_id');

        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);

        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        if ($_GET) {
            $config['base_url'] = site_url('setting/user/?role_id=' . $role_id . '&user_id=' . $user_id);
            $config['total_rows'] = $this->setting->get_user_list($config['per_page'], $offset, $role_id, $user_id, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['users'] = $this->setting->get_user_list($config['per_page'], $offset, $role_id, $user_id, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        } else {
            $config['base_url'] = current_url();
            $config['total_rows'] = $this->setting->get_user_list($config['per_page'], $offset, $role_id, $user_id, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['users'] = $this->setting->get_user_list($config['per_page'], $offset, $role_id, $user_id, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        }
        $this->data['roles'] = $this->setting->get_list('roles', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['role_id'] = $role_id;
        $this->data['user_id'] = $user_id;

        $this->layout->title($this->lang->line('manage_user') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('user/index', $this->data);
    }
}
